/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.construction.resources;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.beam.repackaged.direct_java.runners.core.construction.resources.PipelineResourcesOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.util.ZipFiles;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.hash.Funnels;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.hash.Hasher;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.hash.Hashing;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.hash.PrimitiveSink;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class PipelineResources {
    public static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> detectClassPathResourcesToStage(@UnknownKeyFor @NonNull @Initialized ClassLoader classLoader, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        PipelineResourcesOptions artifactsRelatedOptions = (PipelineResourcesOptions)options.as(PipelineResourcesOptions.class);
        List<String> detectedResources = artifactsRelatedOptions.getPipelineResourcesDetector().detect(classLoader);
        return detectedResources.stream().filter(PipelineResources.isStageable()).collect(Collectors.toList());
    }

    private static @UnknownKeyFor @NonNull @Initialized Predicate<@UnknownKeyFor @NonNull @Initialized String> isStageable() {
        return resourcePath -> !resourcePath.contains("gradle/wrapper");
    }

    public static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> prepareFilesForStaging(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> resourcesToStage, @UnknownKeyFor @NonNull @Initialized String tmpJarLocation) {
        return resourcesToStage.stream().map(File::new).map(file -> {
            Preconditions.checkState((boolean)file.exists(), (String)"To-be-staged file does not exist: '%s'", (Object)file);
            return file.isDirectory() ? PipelineResources.packageDirectoriesToStage(file, tmpJarLocation) : file.getAbsolutePath();
        }).collect(Collectors.toList());
    }

    private static @UnknownKeyFor @NonNull @Initialized String packageDirectoriesToStage(@UnknownKeyFor @NonNull @Initialized File directoryToStage, @UnknownKeyFor @NonNull @Initialized String tmpJarLocation) {
        String hash = PipelineResources.calculateDirectoryContentHash(directoryToStage);
        String pathForJar = PipelineResources.getUniqueJarPath(hash, tmpJarLocation);
        PipelineResources.zipDirectory(directoryToStage, pathForJar);
        return pathForJar;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static @UnknownKeyFor @NonNull @Initialized String calculateDirectoryContentHash(@UnknownKeyFor @NonNull @Initialized File directoryToStage) {
        Hasher hasher = Hashing.sha256().newHasher();
        try (OutputStream hashStream = Funnels.asOutputStream((PrimitiveSink)hasher);){
            ZipFiles.zipDirectory((File)directoryToStage, (OutputStream)hashStream);
            String string = hasher.hash().toString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized String getUniqueJarPath(@UnknownKeyFor @NonNull @Initialized String contentHash, @UnknownKeyFor @NonNull @Initialized String tmpJarLocation) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)tmpJarLocation) ? 1 : 0) != 0, (Object)"Please provide temporary location for storing the jar files.");
        return String.format("%s%s%s.jar", tmpJarLocation, File.separator, contentHash);
    }

    private static void zipDirectory(@UnknownKeyFor @NonNull @Initialized File directoryToStage, @UnknownKeyFor @NonNull @Initialized String uniqueDirectoryPath) {
        try {
            ZipFiles.zipDirectory((File)directoryToStage, (OutputStream)new FileOutputStream(uniqueDirectoryPath));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

