/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.metrics;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.beam.sdk.metrics.MetricName;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Strings;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class MonitoringInfoMetricName
extends MetricName {
    private @UnknownKeyFor @NonNull @Initialized String urn;
    private @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> labels = new HashMap<String, String>();

    private MonitoringInfoMetricName(@UnknownKeyFor @NonNull @Initialized String urn, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> labels) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)urn) ? 1 : 0) != 0, (Object)"MonitoringInfoMetricName urn must be non-empty");
        Preconditions.checkArgument((labels != null ? 1 : 0) != 0, (Object)"MonitoringInfoMetricName labels must be non-null");
        this.urn = urn;
        for (Map.Entry<String, String> entry : labels.entrySet()) {
            this.labels.put(entry.getKey(), entry.getValue());
        }
    }

    public @UnknownKeyFor @NonNull @Initialized String getNamespace() {
        if (this.labels.containsKey("NAMESPACE")) {
            return this.labels.getOrDefault("NAMESPACE", null);
        }
        if (this.labels.containsKey("PCOLLECTION")) {
            return this.labels.getOrDefault("PCOLLECTION", null);
        }
        if (this.labels.containsKey("PTRANSFORM")) {
            return this.labels.getOrDefault("PTRANSFORM", null);
        }
        return this.urn.split(":", 2)[0];
    }

    public @UnknownKeyFor @NonNull @Initialized String getName() {
        if (this.labels.containsKey("NAME")) {
            return this.labels.getOrDefault("NAME", null);
        }
        return this.urn.split(":", 2)[1];
    }

    public @UnknownKeyFor @NonNull @Initialized String getUrn() {
        return this.urn;
    }

    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> getLabels() {
        return this.labels;
    }

    public static @UnknownKeyFor @NonNull @Initialized MonitoringInfoMetricName of(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized MetricsApi.MonitoringInfo mi) {
        return new MonitoringInfoMetricName(mi.getUrn(), mi.getLabelsMap());
    }

    public static @UnknownKeyFor @NonNull @Initialized MonitoringInfoMetricName named(@UnknownKeyFor @NonNull @Initialized String urn, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> labels) {
        return new MonitoringInfoMetricName(urn, labels);
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.urn, this.labels);
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MonitoringInfoMetricName)) {
            return false;
        }
        MonitoringInfoMetricName other = (MonitoringInfoMetricName)((Object)o);
        return this.urn.equals(other.urn) && this.labels.equals(other.labels);
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.urn.toString());
        builder.append(" ");
        builder.append(this.labels.toString());
        return builder.toString();
    }
}

