/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.sdk.fn.stream;

import java.util.concurrent.Phaser;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.beam.vendor.grpc.v1p26p0.io.grpc.stub.CallStreamObserver;
import org.apache.beam.vendor.grpc.v1p26p0.io.grpc.stub.StreamObserver;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class DirectStreamObserver<@UnknownKeyFor T>
implements StreamObserver<T> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(DirectStreamObserver.class);
    private static final @UnknownKeyFor @NonNull @Initialized int DEFAULT_MAX_MESSAGES_BEFORE_CHECK = 100;
    private final @UnknownKeyFor @NonNull @Initialized Phaser phaser;
    private final @UnknownKeyFor @NonNull @Initialized CallStreamObserver<T> outboundObserver;
    private final @UnknownKeyFor @NonNull @Initialized int maxMessagesBeforeCheck;
    private @UnknownKeyFor @NonNull @Initialized int numberOfMessagesBeforeReadyCheck;

    public DirectStreamObserver(@UnknownKeyFor @NonNull @Initialized Phaser phaser, @UnknownKeyFor @NonNull @Initialized CallStreamObserver<T> outboundObserver) {
        this(phaser, outboundObserver, 100);
    }

    DirectStreamObserver(@UnknownKeyFor @NonNull @Initialized Phaser phaser, @UnknownKeyFor @NonNull @Initialized CallStreamObserver<T> outboundObserver, @UnknownKeyFor @NonNull @Initialized int maxMessagesBeforeCheck) {
        this.phaser = phaser;
        this.outboundObserver = outboundObserver;
        this.maxMessagesBeforeCheck = maxMessagesBeforeCheck;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNext(T value) {
        ++this.numberOfMessagesBeforeReadyCheck;
        if (this.numberOfMessagesBeforeReadyCheck >= this.maxMessagesBeforeCheck) {
            this.numberOfMessagesBeforeReadyCheck = 0;
            int waitTime = 1;
            int totalTimeWaited = 0;
            int phase = this.phaser.getPhase();
            while (!this.outboundObserver.isReady()) {
                try {
                    this.phaser.awaitAdvanceInterruptibly(phase, waitTime, TimeUnit.SECONDS);
                }
                catch (TimeoutException e) {
                    totalTimeWaited += waitTime;
                    waitTime *= 2;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
            }
            if (totalTimeWaited > 0) {
                if (phase == this.phaser.getPhase()) {
                    LOG.info("Output channel stalled for {}s, outbound thread {}. See: https://issues.apache.org/jira/browse/BEAM-4280 for the history for this issue.", (Object)totalTimeWaited, (Object)Thread.currentThread().getName());
                } else {
                    LOG.debug("Output channel stalled for {}s, outbound thread {}.", (Object)totalTimeWaited, (Object)Thread.currentThread().getName());
                }
            }
        }
        CallStreamObserver<T> callStreamObserver = this.outboundObserver;
        synchronized (callStreamObserver) {
            this.outboundObserver.onNext(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onError(@UnknownKeyFor @NonNull @Initialized Throwable t) {
        CallStreamObserver<T> callStreamObserver = this.outboundObserver;
        synchronized (callStreamObserver) {
            this.outboundObserver.onError(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCompleted() {
        CallStreamObserver<T> callStreamObserver = this.outboundObserver;
        synchronized (callStreamObserver) {
            this.outboundObserver.onCompleted();
        }
    }
}

