/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import java.util.stream.StreamSupport;
import org.apache.beam.repackaged.direct_java.runners.core.StateNamespace;
import org.apache.beam.repackaged.direct_java.runners.core.TimerInternals;
import org.apache.beam.runners.direct.Clock;
import org.apache.beam.runners.direct.WatermarkManager;
import org.apache.beam.sdk.state.TimeDomain;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;

class DirectTimerInternals
implements TimerInternals {
    private final @UnknownKeyFor @NonNull @Initialized Clock processingTimeClock;
    private final  @UnknownKeyFor @NonNull @Initialized WatermarkManager. @UnknownKeyFor @NonNull @Initialized TransformWatermarks watermarks;
    private final @UnknownKeyFor @NonNull @Initialized WatermarkManager.TimerUpdate.TimerUpdateBuilder timerUpdateBuilder;

    public static @UnknownKeyFor @NonNull @Initialized DirectTimerInternals create(@UnknownKeyFor @NonNull @Initialized Clock clock,  @UnknownKeyFor @NonNull @Initialized WatermarkManager. @UnknownKeyFor @NonNull @Initialized TransformWatermarks watermarks, @UnknownKeyFor @NonNull @Initialized WatermarkManager.TimerUpdate.TimerUpdateBuilder timerUpdateBuilder) {
        return new DirectTimerInternals(clock, watermarks, timerUpdateBuilder);
    }

    private DirectTimerInternals(@UnknownKeyFor @NonNull @Initialized Clock clock,  @UnknownKeyFor @NonNull @Initialized WatermarkManager. @UnknownKeyFor @NonNull @Initialized TransformWatermarks watermarks, @UnknownKeyFor @NonNull @Initialized WatermarkManager.TimerUpdate.TimerUpdateBuilder timerUpdateBuilder) {
        this.processingTimeClock = clock;
        this.watermarks = watermarks;
        this.timerUpdateBuilder = timerUpdateBuilder;
    }

    @Override
    public void setTimer(@UnknownKeyFor @NonNull @Initialized StateNamespace namespace, @UnknownKeyFor @NonNull @Initialized String timerId, @UnknownKeyFor @NonNull @Initialized String timerFamilyId, @UnknownKeyFor @NonNull @Initialized Instant target, @UnknownKeyFor @NonNull @Initialized Instant outputTimestamp, @UnknownKeyFor @NonNull @Initialized TimeDomain timeDomain) {
        this.timerUpdateBuilder.setTimer(TimerInternals.TimerData.of(timerId, timerFamilyId, namespace, target, outputTimestamp, timeDomain));
    }

    @Override
    @Deprecated
    public void setTimer(@UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData timerData) {
        this.timerUpdateBuilder.setTimer(timerData);
    }

    @Override
    public void deleteTimer(@UnknownKeyFor @NonNull @Initialized StateNamespace namespace, @UnknownKeyFor @NonNull @Initialized String timerId, @UnknownKeyFor @NonNull @Initialized TimeDomain timeDomain) {
        throw new UnsupportedOperationException("Canceling of timer by ID is not yet supported.");
    }

    @Override
    @Deprecated
    public void deleteTimer(@UnknownKeyFor @NonNull @Initialized StateNamespace namespace, @UnknownKeyFor @NonNull @Initialized String timerId, @UnknownKeyFor @NonNull @Initialized String timerFamilyId) {
        throw new UnsupportedOperationException("Canceling of timer by ID is not yet supported.");
    }

    @Override
    @Deprecated
    public void deleteTimer(@UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData timerKey) {
        this.timerUpdateBuilder.deletedTimer(timerKey);
    }

    public @UnknownKeyFor @NonNull @Initialized WatermarkManager.TimerUpdate getTimerUpdate() {
        return this.timerUpdateBuilder.build();
    }

    public @UnknownKeyFor @NonNull @Initialized boolean containsUpdateForTimeBefore(@UnknownKeyFor @NonNull @Initialized Instant time) {
        WatermarkManager.TimerUpdate update = this.timerUpdateBuilder.build();
        return this.hasTimeBefore(update.getSetTimers(), time) || this.hasTimeBefore(update.getDeletedTimers(), time);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Instant currentProcessingTime() {
        return this.processingTimeClock.now();
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Instant currentSynchronizedProcessingTime() {
        return this.watermarks.getSynchronizedProcessingInputTime();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Instant currentInputWatermarkTime() {
        return this.watermarks.getInputWatermark();
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Instant currentOutputWatermarkTime() {
        return this.watermarks.getOutputWatermark();
    }

    private @UnknownKeyFor @NonNull @Initialized boolean hasTimeBefore(@UnknownKeyFor @NonNull @Initialized Iterable<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData> timers, @UnknownKeyFor @NonNull @Initialized Instant time) {
        return StreamSupport.stream(timers.spliterator(), false).anyMatch(td -> td.getTimestamp().isBefore((ReadableInstant)time));
    }
}

