/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.beam.repackaged.direct_java.runners.core.SplittableParDoViaKeyedWorkItems;
import org.apache.beam.repackaged.direct_java.runners.core.construction.PTransformTranslation;
import org.apache.beam.repackaged.direct_java.runners.core.construction.TransformPayloadTranslatorRegistrar;
import org.apache.beam.runners.direct.CommittedBundle;
import org.apache.beam.runners.direct.CreateViewNoopEvaluatorFactory;
import org.apache.beam.runners.direct.DirectGroupByKey;
import org.apache.beam.runners.direct.DirectWriteViewVisitor;
import org.apache.beam.runners.direct.EvaluationContext;
import org.apache.beam.runners.direct.FlattenEvaluatorFactory;
import org.apache.beam.runners.direct.GroupAlsoByWindowEvaluatorFactory;
import org.apache.beam.runners.direct.GroupByKeyOnlyEvaluatorFactory;
import org.apache.beam.runners.direct.ImpulseEvaluatorFactory;
import org.apache.beam.runners.direct.MultiStepCombine;
import org.apache.beam.runners.direct.ParDoEvaluator;
import org.apache.beam.runners.direct.ParDoEvaluatorFactory;
import org.apache.beam.runners.direct.ParDoMultiOverrideFactory;
import org.apache.beam.runners.direct.ReadEvaluatorFactory;
import org.apache.beam.runners.direct.SplittableProcessElementsEvaluatorFactory;
import org.apache.beam.runners.direct.StatefulParDoEvaluatorFactory;
import org.apache.beam.runners.direct.TestStreamEvaluatorFactory;
import org.apache.beam.runners.direct.TransformEvaluator;
import org.apache.beam.runners.direct.TransformEvaluatorFactory;
import org.apache.beam.runners.direct.ViewEvaluatorFactory;
import org.apache.beam.runners.direct.WindowEvaluatorFactory;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TransformEvaluatorRegistry {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(TransformEvaluatorRegistry.class);
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized TransformEvaluatorFactory> factories;
    private final @UnknownKeyFor @NonNull @Initialized AtomicBoolean finished = new AtomicBoolean(false);

    public static @UnknownKeyFor @NonNull @Initialized TransformEvaluatorRegistry javaSdkNativeRegistry(@UnknownKeyFor @NonNull @Initialized EvaluationContext ctxt, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        ImmutableMap primitives = ImmutableMap.builder().put((Object)"beam:transform:read:v1", (Object)new ReadEvaluatorFactory(ctxt, options)).put((Object)"beam:transform:pardo:v1", new ParDoEvaluatorFactory(ctxt, ParDoEvaluator.defaultRunnerFactory(), ParDoEvaluatorFactory.basicDoFnCacheLoader(), options)).put((Object)"beam:transform:flatten:v1", (Object)new FlattenEvaluatorFactory(ctxt)).put((Object)"beam:transform:window_into:v1", (Object)new WindowEvaluatorFactory(ctxt)).put((Object)"beam:transform:impulse:v1", (Object)new ImpulseEvaluatorFactory(ctxt)).put((Object)"beam:directrunner:transforms:write_view:v1", (Object)new ViewEvaluatorFactory(ctxt)).put((Object)"beam:directrunner:transforms:stateful_pardo:v1", new StatefulParDoEvaluatorFactory(ctxt, options)).put((Object)"beam:directrunner:transforms:gbko:v1", (Object)new GroupByKeyOnlyEvaluatorFactory(ctxt)).put((Object)"beam:directrunner:transforms:gabw:v1", (Object)new GroupAlsoByWindowEvaluatorFactory(ctxt, options)).put((Object)"beam:directrunner:transforms:test_stream:v1", (Object)new TestStreamEvaluatorFactory(ctxt)).put((Object)"beam:directrunner:transforms:merge_accumulators_extract_output:v1", (Object)new MultiStepCombine.MergeAndExtractAccumulatorOutputEvaluatorFactory(ctxt)).put((Object)"beam:runners_core:transforms:splittable_process:v1", new SplittableProcessElementsEvaluatorFactory(ctxt, options)).put((Object)"beam:transform:create_view:v1", (Object)new CreateViewNoopEvaluatorFactory()).build();
        return new TransformEvaluatorRegistry((Map<String, TransformEvaluatorFactory>)primitives);
    }

    private TransformEvaluatorRegistry(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized TransformEvaluatorFactory> factories) {
        this.factories = factories;
    }

    public <InputT> @Nullable @UnknownKeyFor @Initialized TransformEvaluator<InputT> forApplication(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized ?> application, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized CommittedBundle<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> inputBundle) throws @UnknownKeyFor @NonNull @Initialized Exception {
        Preconditions.checkState((!this.finished.get() ? 1 : 0) != 0, (Object)"Tried to get an evaluator for a finished TransformEvaluatorRegistry");
        String urn = PTransformTranslation.urnForTransform(application.getTransform());
        TransformEvaluatorFactory factory = (TransformEvaluatorFactory)Preconditions.checkNotNull((Object)this.factories.get(urn), (String)"No evaluator for PTransform \"%s\"", (Object)urn);
        return factory.forApplication(application, inputBundle);
    }

    public void cleanup() throws @UnknownKeyFor @NonNull @Initialized Exception {
        ArrayList<Exception> thrownInCleanup = new ArrayList<Exception>();
        for (TransformEvaluatorFactory factory : this.factories.values()) {
            try {
                factory.cleanup();
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                thrownInCleanup.add(e);
            }
        }
        this.finished.set(true);
        if (!thrownInCleanup.isEmpty()) {
            LOG.error("Exceptions {} thrown while cleaning up evaluators", thrownInCleanup);
            Exception toThrow = null;
            for (Exception e : thrownInCleanup) {
                if (toThrow == null) {
                    toThrow = e;
                    continue;
                }
                toThrow.addSuppressed(e);
            }
            throw toThrow;
        }
    }

    private static class SplittableParDoProcessElementsTranslator
    extends PTransformTranslation.TransformPayloadTranslator.NotSerializable<SplittableParDoViaKeyedWorkItems.ProcessElements<?, ?, ?, ?, ?>> {
        private SplittableParDoProcessElementsTranslator() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized String getUrn(/*
         * Issues handling annotations - annotations may be inaccurate
         */
         @UnknownKeyFor @NonNull @Initialized SplittableParDoViaKeyedWorkItems.ProcessElements<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> transform) {
            return "beam:runners_core:transforms:splittable_process:v1";
        }
    }

    public static class DirectTransformsRegistrar
    implements TransformPayloadTranslatorRegistrar {
        @Override
        public @UnknownKeyFor @NonNull @Initialized Map<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PTransform>, @KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PTransformTranslation.TransformPayloadTranslator> getTransformPayloadTranslators() {
            return ImmutableMap.builder().put(DirectGroupByKey.DirectGroupByKeyOnly.class, PTransformTranslation.TransformPayloadTranslator.NotSerializable.forUrn("beam:directrunner:transforms:gbko:v1")).put(DirectGroupByKey.DirectGroupAlsoByWindow.class, PTransformTranslation.TransformPayloadTranslator.NotSerializable.forUrn("beam:directrunner:transforms:gabw:v1")).put(ParDoMultiOverrideFactory.StatefulParDo.class, PTransformTranslation.TransformPayloadTranslator.NotSerializable.forUrn("beam:directrunner:transforms:stateful_pardo:v1")).put(DirectWriteViewVisitor.WriteView.class, PTransformTranslation.TransformPayloadTranslator.NotSerializable.forUrn("beam:directrunner:transforms:write_view:v1")).put(TestStreamEvaluatorFactory.DirectTestStreamFactory.DirectTestStream.class, PTransformTranslation.TransformPayloadTranslator.NotSerializable.forUrn("beam:directrunner:transforms:test_stream:v1")).put(SplittableParDoViaKeyedWorkItems.ProcessElements.class, PTransformTranslation.TransformPayloadTranslator.NotSerializable.forUrn("beam:runners_core:transforms:splittable_process:v1")).build();
        }
    }
}

