
package org.apache.beam.runners.direct;

import java.util.Set;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import org.apache.beam.runners.core.metrics.MetricUpdates;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.util.WindowedValue;
import org.joda.time.Instant;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_StepTransformResult<InputT> extends StepTransformResult<InputT> {

  private final AppliedPTransform<?, ?, ?> transform;
  private final Iterable<? extends UncommittedBundle<?>> outputBundles;
  private final Iterable<? extends WindowedValue<InputT>> unprocessedElements;
  private final MetricUpdates logicalMetricUpdates;
  private final Instant watermarkHold;
  private final CopyOnAccessInMemoryStateInternals state;
  private final WatermarkManager.TimerUpdate timerUpdate;
  private final Set<CommittedResult.OutputType> outputTypes;

  AutoValue_StepTransformResult(
      AppliedPTransform<?, ?, ?> transform,
      Iterable<? extends UncommittedBundle<?>> outputBundles,
      Iterable<? extends WindowedValue<InputT>> unprocessedElements,
      MetricUpdates logicalMetricUpdates,
      Instant watermarkHold,
      @Nullable CopyOnAccessInMemoryStateInternals state,
      WatermarkManager.TimerUpdate timerUpdate,
      Set<CommittedResult.OutputType> outputTypes) {
    if (transform == null) {
      throw new NullPointerException("Null transform");
    }
    this.transform = transform;
    if (outputBundles == null) {
      throw new NullPointerException("Null outputBundles");
    }
    this.outputBundles = outputBundles;
    if (unprocessedElements == null) {
      throw new NullPointerException("Null unprocessedElements");
    }
    this.unprocessedElements = unprocessedElements;
    if (logicalMetricUpdates == null) {
      throw new NullPointerException("Null logicalMetricUpdates");
    }
    this.logicalMetricUpdates = logicalMetricUpdates;
    if (watermarkHold == null) {
      throw new NullPointerException("Null watermarkHold");
    }
    this.watermarkHold = watermarkHold;
    this.state = state;
    if (timerUpdate == null) {
      throw new NullPointerException("Null timerUpdate");
    }
    this.timerUpdate = timerUpdate;
    if (outputTypes == null) {
      throw new NullPointerException("Null outputTypes");
    }
    this.outputTypes = outputTypes;
  }

  @Override
  public AppliedPTransform<?, ?, ?> getTransform() {
    return transform;
  }

  @Override
  public Iterable<? extends UncommittedBundle<?>> getOutputBundles() {
    return outputBundles;
  }

  @Override
  public Iterable<? extends WindowedValue<InputT>> getUnprocessedElements() {
    return unprocessedElements;
  }

  @Override
  public MetricUpdates getLogicalMetricUpdates() {
    return logicalMetricUpdates;
  }

  @Override
  public Instant getWatermarkHold() {
    return watermarkHold;
  }

  @Nullable
  @Override
  public CopyOnAccessInMemoryStateInternals getState() {
    return state;
  }

  @Override
  public WatermarkManager.TimerUpdate getTimerUpdate() {
    return timerUpdate;
  }

  @Override
  public Set<CommittedResult.OutputType> getOutputTypes() {
    return outputTypes;
  }

  @Override
  public String toString() {
    return "StepTransformResult{"
        + "transform=" + transform + ", "
        + "outputBundles=" + outputBundles + ", "
        + "unprocessedElements=" + unprocessedElements + ", "
        + "logicalMetricUpdates=" + logicalMetricUpdates + ", "
        + "watermarkHold=" + watermarkHold + ", "
        + "state=" + state + ", "
        + "timerUpdate=" + timerUpdate + ", "
        + "outputTypes=" + outputTypes
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof StepTransformResult) {
      StepTransformResult<?> that = (StepTransformResult<?>) o;
      return (this.transform.equals(that.getTransform()))
           && (this.outputBundles.equals(that.getOutputBundles()))
           && (this.unprocessedElements.equals(that.getUnprocessedElements()))
           && (this.logicalMetricUpdates.equals(that.getLogicalMetricUpdates()))
           && (this.watermarkHold.equals(that.getWatermarkHold()))
           && ((this.state == null) ? (that.getState() == null) : this.state.equals(that.getState()))
           && (this.timerUpdate.equals(that.getTimerUpdate()))
           && (this.outputTypes.equals(that.getOutputTypes()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= this.transform.hashCode();
    h *= 1000003;
    h ^= this.outputBundles.hashCode();
    h *= 1000003;
    h ^= this.unprocessedElements.hashCode();
    h *= 1000003;
    h ^= this.logicalMetricUpdates.hashCode();
    h *= 1000003;
    h ^= this.watermarkHold.hashCode();
    h *= 1000003;
    h ^= (state == null) ? 0 : this.state.hashCode();
    h *= 1000003;
    h ^= this.timerUpdate.hashCode();
    h *= 1000003;
    h ^= this.outputTypes.hashCode();
    return h;
  }

}
