/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.beam.runners.direct.Clock;
import org.apache.beam.runners.direct.CopyOnAccessInMemoryStateInternals;
import org.apache.beam.runners.direct.DirectTimerInternals;
import org.apache.beam.runners.direct.WatermarkManager;
import org.apache.beam.runners.direct.repackaged.runners.core.StepContext;
import org.apache.beam.runners.local.StructuralKey;

class DirectExecutionContext {
    private final Clock clock;
    private final StructuralKey<?> key;
    private final CopyOnAccessInMemoryStateInternals existingState;
    private final WatermarkManager.TransformWatermarks watermarks;
    private Map<String, DirectStepContext> cachedStepContexts = new LinkedHashMap<String, DirectStepContext>();

    public DirectExecutionContext(Clock clock, StructuralKey<?> key, CopyOnAccessInMemoryStateInternals existingState, WatermarkManager.TransformWatermarks watermarks) {
        this.clock = clock;
        this.key = key;
        this.existingState = existingState;
        this.watermarks = watermarks;
    }

    private DirectStepContext createStepContext() {
        return new DirectStepContext();
    }

    public DirectStepContext getStepContext(String stepName) {
        return this.cachedStepContexts.computeIfAbsent(stepName, k -> this.createStepContext());
    }

    public class DirectStepContext
    implements StepContext {
        private CopyOnAccessInMemoryStateInternals<?> stateInternals;
        private DirectTimerInternals timerInternals;

        @Override
        public CopyOnAccessInMemoryStateInternals<?> stateInternals() {
            if (this.stateInternals == null) {
                this.stateInternals = CopyOnAccessInMemoryStateInternals.withUnderlying(DirectExecutionContext.this.key, DirectExecutionContext.this.existingState);
            }
            return this.stateInternals;
        }

        @Override
        public DirectTimerInternals timerInternals() {
            if (this.timerInternals == null) {
                this.timerInternals = DirectTimerInternals.create(DirectExecutionContext.this.clock, DirectExecutionContext.this.watermarks, WatermarkManager.TimerUpdate.builder(DirectExecutionContext.this.key));
            }
            return this.timerInternals;
        }

        public CopyOnAccessInMemoryStateInternals commitState() {
            if (this.stateInternals != null) {
                return this.stateInternals.commit();
            }
            return null;
        }

        public WatermarkManager.TimerUpdate getTimerUpdate() {
            if (this.timerInternals == null) {
                return WatermarkManager.TimerUpdate.empty();
            }
            return this.timerInternals.getTimerUpdate();
        }
    }
}

