/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.beam.runners.direct.repackaged.com.google.common.base.Preconditions;
import org.apache.beam.runners.direct.repackaged.com.google.common.collect.ListMultimap;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.PValue;

class DirectGraph {
    private final Map<PCollection<?>, AppliedPTransform<?, ?, ?>> producers;
    private final Map<PCollectionView<?>, AppliedPTransform<?, ?, ?>> viewWriters;
    private final ListMultimap<PInput, AppliedPTransform<?, ?, ?>> perElementConsumers;
    private final ListMultimap<PValue, AppliedPTransform<?, ?, ?>> allConsumers;
    private final Set<AppliedPTransform<?, ?, ?>> rootTransforms;
    private final Map<AppliedPTransform<?, ?, ?>, String> stepNames;

    public static DirectGraph create(Map<PCollection<?>, AppliedPTransform<?, ?, ?>> producers, Map<PCollectionView<?>, AppliedPTransform<?, ?, ?>> viewWriters, ListMultimap<PInput, AppliedPTransform<?, ?, ?>> perElementConsumers, ListMultimap<PValue, AppliedPTransform<?, ?, ?>> allConsumers, Set<AppliedPTransform<?, ?, ?>> rootTransforms, Map<AppliedPTransform<?, ?, ?>, String> stepNames) {
        return new DirectGraph(producers, viewWriters, perElementConsumers, allConsumers, rootTransforms, stepNames);
    }

    private DirectGraph(Map<PCollection<?>, AppliedPTransform<?, ?, ?>> producers, Map<PCollectionView<?>, AppliedPTransform<?, ?, ?>> viewWriters, ListMultimap<PInput, AppliedPTransform<?, ?, ?>> perElementConsumers, ListMultimap<PValue, AppliedPTransform<?, ?, ?>> allConsumers, Set<AppliedPTransform<?, ?, ?>> rootTransforms, Map<AppliedPTransform<?, ?, ?>, String> stepNames) {
        this.producers = producers;
        this.viewWriters = viewWriters;
        this.perElementConsumers = perElementConsumers;
        this.allConsumers = allConsumers;
        this.rootTransforms = rootTransforms;
        this.stepNames = stepNames;
        for (AppliedPTransform<?, ?, ?> step : stepNames.keySet()) {
            for (PValue input : step.getInputs().values()) {
                Preconditions.checkArgument(allConsumers.get(input).contains(step), "Step %s lists value %s as input, but it is not in the graph of consumers", (Object)step.getFullName(), (Object)input);
            }
        }
    }

    AppliedPTransform<?, ?, ?> getProducer(PCollection<?> produced) {
        return this.producers.get(produced);
    }

    AppliedPTransform<?, ?, ?> getWriter(PCollectionView<?> view) {
        return this.viewWriters.get(view);
    }

    List<AppliedPTransform<?, ?, ?>> getPerElementConsumers(PValue consumed) {
        return this.perElementConsumers.get((PInput)consumed);
    }

    List<AppliedPTransform<?, ?, ?>> getAllConsumers(PValue consumed) {
        return this.allConsumers.get(consumed);
    }

    Set<AppliedPTransform<?, ?, ?>> getRootTransforms() {
        return this.rootTransforms;
    }

    Set<PCollection<?>> getPCollections() {
        return this.producers.keySet();
    }

    Set<PCollectionView<?>> getViews() {
        return this.viewWriters.keySet();
    }

    String getStepName(AppliedPTransform<?, ?, ?> step) {
        return this.stepNames.get(step);
    }

    Collection<AppliedPTransform<?, ?, ?>> getPrimitiveTransforms() {
        return this.stepNames.keySet();
    }
}

