/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import org.apache.beam.runners.direct.repackaged.com.google.common.base.Preconditions;
import org.apache.beam.runners.direct.repackaged.runners.core.KeyedWorkItem;
import org.apache.beam.runners.direct.repackaged.runners.core.KeyedWorkItemCoder;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.ForwardingPTransform;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.transforms.GroupByKey;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.WindowingStrategy;

class DirectGroupByKey<K, V>
extends ForwardingPTransform<PCollection<KV<K, V>>, PCollection<KV<K, Iterable<V>>>> {
    private final PTransform<PCollection<KV<K, V>>, PCollection<KV<K, Iterable<V>>>> original;
    static final String DIRECT_GBKO_URN = "urn:beam:directrunner:transforms:gbko:v1";
    static final String DIRECT_GABW_URN = "urn:beam:directrunner:transforms:gabw:v1";
    private final WindowingStrategy<?, ?> outputWindowingStrategy;

    DirectGroupByKey(PTransform<PCollection<KV<K, V>>, PCollection<KV<K, Iterable<V>>>> original, WindowingStrategy<?, ?> outputWindowingStrategy) {
        this.original = original;
        this.outputWindowingStrategy = outputWindowingStrategy;
    }

    @Override
    public PTransform<PCollection<KV<K, V>>, PCollection<KV<K, Iterable<V>>>> delegate() {
        return this.original;
    }

    @Override
    public PCollection<KV<K, Iterable<V>>> expand(PCollection<KV<K, V>> input) {
        WindowingStrategy inputWindowingStrategy = input.getWindowingStrategy();
        return (PCollection)((PCollection)input.apply(new DirectGroupByKeyOnly())).apply("GroupAlsoByWindow", new DirectGroupAlsoByWindow(inputWindowingStrategy, this.outputWindowingStrategy));
    }

    static final class DirectGroupAlsoByWindow<K, V>
    extends PTransform<PCollection<KeyedWorkItem<K, V>>, PCollection<KV<K, Iterable<V>>>> {
        private final WindowingStrategy<?, ?> inputWindowingStrategy;
        private final WindowingStrategy<?, ?> outputWindowingStrategy;

        public DirectGroupAlsoByWindow(WindowingStrategy<?, ?> inputWindowingStrategy, WindowingStrategy<?, ?> outputWindowingStrategy) {
            this.inputWindowingStrategy = inputWindowingStrategy;
            this.outputWindowingStrategy = outputWindowingStrategy;
        }

        public WindowingStrategy<?, ?> getInputWindowingStrategy() {
            return this.inputWindowingStrategy;
        }

        private KeyedWorkItemCoder<K, V> getKeyedWorkItemCoder(Coder<KeyedWorkItem<K, V>> inputCoder) {
            Preconditions.checkArgument(inputCoder instanceof KeyedWorkItemCoder, "%s requires a %s<...> but got %s", (Object)((Object)((Object)this)).getClass().getSimpleName(), (Object)KvCoder.class.getSimpleName(), inputCoder);
            KeyedWorkItemCoder kvCoder = (KeyedWorkItemCoder)inputCoder;
            return kvCoder;
        }

        public Coder<V> getValueCoder(Coder<KeyedWorkItem<K, V>> inputCoder) {
            return this.getKeyedWorkItemCoder(inputCoder).getElementCoder();
        }

        public PCollection<KV<K, Iterable<V>>> expand(PCollection<KeyedWorkItem<K, V>> input) {
            KeyedWorkItemCoder<K, V> inputCoder = this.getKeyedWorkItemCoder(input.getCoder());
            return PCollection.createPrimitiveOutputInternal((Pipeline)input.getPipeline(), this.outputWindowingStrategy, (PCollection.IsBounded)input.isBounded(), (Coder)KvCoder.of(inputCoder.getKeyCoder(), (Coder)IterableCoder.of(inputCoder.getElementCoder())));
        }
    }

    static final class DirectGroupByKeyOnly<K, V>
    extends PTransform<PCollection<KV<K, V>>, PCollection<KeyedWorkItem<K, V>>> {
        public PCollection<KeyedWorkItem<K, V>> expand(PCollection<KV<K, V>> input) {
            return PCollection.createPrimitiveOutputInternal((Pipeline)input.getPipeline(), (WindowingStrategy)WindowingStrategy.globalDefault(), (PCollection.IsBounded)input.isBounded(), KeyedWorkItemCoder.of(GroupByKey.getKeyCoder((Coder)input.getCoder()), GroupByKey.getInputValueCoder((Coder)input.getCoder()), (Coder<? extends BoundedWindow>)input.getWindowingStrategy().getWindowFn().windowCoder()));
        }

        DirectGroupByKeyOnly() {
        }
    }
}

