/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import org.apache.beam.runners.direct.Clock;
import org.apache.beam.runners.direct.WatermarkManager;
import org.apache.beam.runners.direct.repackaged.javax.annotation.Nullable;
import org.apache.beam.runners.direct.repackaged.runners.core.StateNamespace;
import org.apache.beam.runners.direct.repackaged.runners.core.TimerInternals;
import org.apache.beam.sdk.state.TimeDomain;
import org.joda.time.Instant;

class DirectTimerInternals
implements TimerInternals {
    private final Clock processingTimeClock;
    private final WatermarkManager.TransformWatermarks watermarks;
    private final WatermarkManager.TimerUpdate.TimerUpdateBuilder timerUpdateBuilder;

    public static DirectTimerInternals create(Clock clock, WatermarkManager.TransformWatermarks watermarks, WatermarkManager.TimerUpdate.TimerUpdateBuilder timerUpdateBuilder) {
        return new DirectTimerInternals(clock, watermarks, timerUpdateBuilder);
    }

    private DirectTimerInternals(Clock clock, WatermarkManager.TransformWatermarks watermarks, WatermarkManager.TimerUpdate.TimerUpdateBuilder timerUpdateBuilder) {
        this.processingTimeClock = clock;
        this.watermarks = watermarks;
        this.timerUpdateBuilder = timerUpdateBuilder;
    }

    @Override
    public void setTimer(StateNamespace namespace, String timerId, Instant target, TimeDomain timeDomain) {
        this.timerUpdateBuilder.setTimer(TimerInternals.TimerData.of(timerId, namespace, target, timeDomain));
    }

    @Override
    @Deprecated
    public void setTimer(TimerInternals.TimerData timerData) {
        this.timerUpdateBuilder.setTimer(timerData);
    }

    @Override
    public void deleteTimer(StateNamespace namespace, String timerId, TimeDomain timeDomain) {
        throw new UnsupportedOperationException("Canceling of timer by ID is not yet supported.");
    }

    @Override
    @Deprecated
    public void deleteTimer(StateNamespace namespace, String timerId) {
        throw new UnsupportedOperationException("Canceling of timer by ID is not yet supported.");
    }

    @Override
    @Deprecated
    public void deleteTimer(TimerInternals.TimerData timerKey) {
        this.timerUpdateBuilder.deletedTimer(timerKey);
    }

    public WatermarkManager.TimerUpdate getTimerUpdate() {
        return this.timerUpdateBuilder.build();
    }

    @Override
    public Instant currentProcessingTime() {
        return this.processingTimeClock.now();
    }

    @Override
    @Nullable
    public Instant currentSynchronizedProcessingTime() {
        return this.watermarks.getSynchronizedProcessingInputTime();
    }

    @Override
    public Instant currentInputWatermarkTime() {
        return this.watermarks.getInputWatermark();
    }

    @Override
    @Nullable
    public Instant currentOutputWatermarkTime() {
        return this.watermarks.getOutputWatermark();
    }
}

