/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct.repackaged.runners.core;

import org.apache.beam.runners.direct.repackaged.runners.core.java.repackaged.com.google.common.collect.ArrayListMultimap;
import org.apache.beam.runners.direct.repackaged.runners.core.java.repackaged.com.google.common.collect.Multimap;
import org.apache.beam.runners.direct.repackaged.runners.core.java.repackaged.com.google.common.collect.Multimaps;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.transforms.Materializations;
import org.apache.beam.sdk.values.KV;

public class InMemoryMultimapSideInputView<K, V>
implements Materializations.MultimapView<K, V> {
    private final Coder<K> keyCoder;
    private final Multimap<Object, V> structuralKeyToValuesMap;

    public static <K, V> Materializations.MultimapView<K, V> fromIterable(Coder<K> keyCoder, Iterable<KV<K, V>> values) {
        ArrayListMultimap<Object, Object> multimap = ArrayListMultimap.create();
        for (KV<K, V> value : values) {
            multimap.put(keyCoder.structuralValue(value.getKey()), value.getValue());
        }
        return new InMemoryMultimapSideInputView(keyCoder, Multimaps.unmodifiableMultimap(multimap));
    }

    private InMemoryMultimapSideInputView(Coder<K> keyCoder, Multimap<Object, V> data) {
        this.keyCoder = keyCoder;
        this.structuralKeyToValuesMap = data;
    }

    public Iterable<V> get(K k) {
        return this.structuralKeyToValuesMap.get(this.keyCoder.structuralValue(k));
    }
}

