/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct.repackaged.runners.core.construction;

import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.beam.runners.direct.repackaged.javax.annotation.Nullable;
import org.apache.beam.runners.direct.repackaged.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.AutoValue_PTransformTranslation_UnknownRawPTransform;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.DisplayDataTranslation;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.RehydratedComponents;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.SdkComponents;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.TransformPayloadTranslatorRegistrar;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.java.repackaged.com.google.common.base.Joiner;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.java.repackaged.com.google.common.base.MoreObjects;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.java.repackaged.com.google.common.base.Preconditions;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.java.repackaged.com.google.common.collect.ImmutableMap;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.java.repackaged.com.google.common.collect.Sets;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;

public class PTransformTranslation {
    public static final String PAR_DO_TRANSFORM_URN = "urn:beam:transform:pardo:v1";
    public static final String FLATTEN_TRANSFORM_URN = "urn:beam:transform:flatten:v1";
    public static final String GROUP_BY_KEY_TRANSFORM_URN = "urn:beam:transform:groupbykey:v1";
    public static final String READ_TRANSFORM_URN = "urn:beam:transform:read:v1";
    public static final String WINDOW_TRANSFORM_URN = "urn:beam:transform:window:v1";
    public static final String TEST_STREAM_TRANSFORM_URN = "urn:beam:transform:teststream:v1";
    public static final String COMBINE_TRANSFORM_URN = "urn:beam:transform:combine:v1";
    public static final String RESHUFFLE_URN = "urn:beam:transform:reshuffle:v1";
    public static final String WRITE_FILES_TRANSFORM_URN = "urn:beam:transform:write_files:0.1";
    @Deprecated
    public static final String CREATE_VIEW_TRANSFORM_URN = "urn:beam:transform:create_view:v1";
    private static final Map<Class<? extends PTransform>, TransformPayloadTranslator> KNOWN_PAYLOAD_TRANSLATORS = PTransformTranslation.loadTransformPayloadTranslators();
    private static final Map<String, TransformPayloadTranslator> KNOWN_REHYDRATORS = PTransformTranslation.loadTransformRehydrators();
    private static final TransformPayloadTranslator<?> DEFAULT_REHYDRATOR = new RawPTransformTranslator();

    private static Map<Class<? extends PTransform>, TransformPayloadTranslator> loadTransformPayloadTranslators() {
        HashMap<? extends Class<? extends PTransform>, ? extends TransformPayloadTranslator> translators = new HashMap<Class<? extends PTransform>, TransformPayloadTranslator>();
        for (TransformPayloadTranslatorRegistrar registrar : ServiceLoader.load(TransformPayloadTranslatorRegistrar.class)) {
            Map<? extends Class<? extends PTransform>, ? extends TransformPayloadTranslator> newTranslators = registrar.getTransformPayloadTranslators();
            Sets.SetView alreadyRegistered = Sets.intersection(translators.keySet(), newTranslators.keySet());
            if (!alreadyRegistered.isEmpty()) {
                throw new IllegalArgumentException(String.format("Classes already registered: %s", Joiner.on(", ").join(alreadyRegistered)));
            }
            translators.putAll(newTranslators);
        }
        return ImmutableMap.copyOf(translators);
    }

    private static Map<String, TransformPayloadTranslator> loadTransformRehydrators() {
        HashMap<String, ? extends TransformPayloadTranslator> rehydrators = new HashMap<String, TransformPayloadTranslator>();
        for (TransformPayloadTranslatorRegistrar registrar : ServiceLoader.load(TransformPayloadTranslatorRegistrar.class)) {
            Map<String, ? extends TransformPayloadTranslator> newRehydrators = registrar.getTransformRehydrators();
            Sets.SetView alreadyRegistered = Sets.intersection(rehydrators.keySet(), newRehydrators.keySet());
            if (!alreadyRegistered.isEmpty()) {
                throw new IllegalArgumentException(String.format("URNs already registered: %s", Joiner.on(", ").join(alreadyRegistered)));
            }
            rehydrators.putAll(newRehydrators);
        }
        return ImmutableMap.copyOf(rehydrators);
    }

    private PTransformTranslation() {
    }

    static RunnerApi.PTransform toProto(AppliedPTransform<?, ?, ?> appliedPTransform, List<AppliedPTransform<?, ?, ?>> subtransforms, SdkComponents components) throws IOException {
        RunnerApi.PTransform.Builder transformBuilder = RunnerApi.PTransform.newBuilder();
        for (Map.Entry entry : appliedPTransform.getInputs().entrySet()) {
            Preconditions.checkArgument(entry.getValue() instanceof PCollection, "Unexpected input type %s", ((PValue)entry.getValue()).getClass());
            transformBuilder.putInputs(PTransformTranslation.toProto((TupleTag)entry.getKey()), components.registerPCollection((PCollection)entry.getValue()));
        }
        for (Map.Entry entry : appliedPTransform.getOutputs().entrySet()) {
            if (!(entry.getValue() instanceof PCollection)) continue;
            Preconditions.checkArgument(entry.getValue() instanceof PCollection, "Unexpected output type %s", ((PValue)entry.getValue()).getClass());
            transformBuilder.putOutputs(PTransformTranslation.toProto((TupleTag)entry.getKey()), components.registerPCollection((PCollection)entry.getValue()));
        }
        for (AppliedPTransform appliedPTransform2 : subtransforms) {
            transformBuilder.addSubtransforms(components.getExistingPTransformId(appliedPTransform2));
        }
        transformBuilder.setUniqueName(appliedPTransform.getFullName());
        transformBuilder.setDisplayData(DisplayDataTranslation.toProto(DisplayData.from((HasDisplayData)appliedPTransform.getTransform())));
        PTransform transform = appliedPTransform.getTransform();
        if (transform instanceof RawPTransform) {
            RunnerApi.FunctionSpec functionSpec = ((RawPTransform)transform).migrate(components);
            if (functionSpec != null) {
                transformBuilder.setSpec(functionSpec);
            }
        } else if (KNOWN_PAYLOAD_TRANSLATORS.containsKey(transform.getClass())) {
            transformBuilder.setSpec(KNOWN_PAYLOAD_TRANSLATORS.get(transform.getClass()).translate(appliedPTransform, components));
        }
        return transformBuilder.build();
    }

    static RawPTransform<?, ?> rehydrate(RunnerApi.PTransform protoTransform, RehydratedComponents rehydratedComponents) throws IOException {
        TransformPayloadTranslator rehydrator = KNOWN_REHYDRATORS.get(protoTransform.getSpec() == null ? null : protoTransform.getSpec().getUrn());
        if (rehydrator == null) {
            return DEFAULT_REHYDRATOR.rehydrate(protoTransform, rehydratedComponents);
        }
        return rehydrator.rehydrate(protoTransform, rehydratedComponents);
    }

    static RunnerApi.PTransform toProto(AppliedPTransform<?, ?, ?> appliedPTransform, SdkComponents components) throws IOException {
        return PTransformTranslation.toProto(appliedPTransform, Collections.emptyList(), components);
    }

    private static String toProto(TupleTag<?> tag) {
        return tag.getId();
    }

    @Nullable
    public static String urnForTransformOrNull(PTransform<?, ?> transform) {
        if (transform instanceof RawPTransform) {
            return ((RawPTransform)transform).getUrn();
        }
        TransformPayloadTranslator translator = KNOWN_PAYLOAD_TRANSLATORS.get(transform.getClass());
        if (translator == null) {
            return null;
        }
        return translator.getUrn(transform);
    }

    public static String urnForTransform(PTransform<?, ?> transform) {
        String urn = PTransformTranslation.urnForTransformOrNull(transform);
        if (urn == null) {
            throw new IllegalStateException(String.format("No translator known for %s", transform.getClass().getName()));
        }
        return urn;
    }

    public static class RawPTransformTranslator
    implements TransformPayloadTranslator<RawPTransform<?, ?>> {
        @Override
        public String getUrn(RawPTransform<?, ?> transform) {
            return transform.getUrn();
        }

        @Override
        public RunnerApi.FunctionSpec translate(AppliedPTransform<?, ?, RawPTransform<?, ?>> transform, SdkComponents components) throws IOException {
            return ((RawPTransform)transform.getTransform()).migrate(components);
        }

        @Override
        public RawPTransform<?, ?> rehydrate(RunnerApi.PTransform protoTransform, RehydratedComponents rehydratedComponents) {
            return UnknownRawPTransform.forSpec(protoTransform.getSpec());
        }
    }

    @AutoValue
    static abstract class UnknownRawPTransform
    extends RawPTransform<PInput, POutput> {
        UnknownRawPTransform() {
        }

        @Override
        public String getUrn() {
            return this.getSpec() == null ? null : this.getSpec().getUrn();
        }

        @Override
        @Nullable
        public abstract RunnerApi.FunctionSpec getSpec();

        public static UnknownRawPTransform forSpec(RunnerApi.FunctionSpec spec) {
            return new AutoValue_PTransformTranslation_UnknownRawPTransform(spec);
        }

        @Override
        public POutput expand(PInput input) {
            throw new IllegalStateException(String.format("%s should never be asked to expand; it is the result of deserializing an already-constructed Pipeline", ((Object)((Object)this)).getClass().getSimpleName()));
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("urn", this.getUrn()).add("payload", this.getSpec()).toString();
        }

        public RunnerApi.FunctionSpec getSpecForComponents(SdkComponents components) {
            return this.getSpec();
        }
    }

    public static abstract class RawPTransform<InputT extends PInput, OutputT extends POutput>
    extends PTransform<InputT, OutputT> {
        @Nullable
        public String getUrn() {
            return this.getSpec() == null ? null : this.getSpec().getUrn();
        }

        @Nullable
        public abstract RunnerApi.FunctionSpec getSpec();

        public RunnerApi.FunctionSpec migrate(SdkComponents components) throws IOException {
            return this.getSpec();
        }

        public OutputT expand(InputT input) {
            throw new IllegalStateException(String.format("%s should never be asked to expand; it is the result of deserializing an already-constructed Pipeline", ((Object)((Object)this)).getClass().getSimpleName()));
        }
    }

    public static interface TransformPayloadTranslator<T extends PTransform<?, ?>> {
        public String getUrn(T var1);

        public RunnerApi.FunctionSpec translate(AppliedPTransform<?, ?, T> var1, SdkComponents var2) throws IOException;

        public RawPTransform<?, ?> rehydrate(RunnerApi.PTransform var1, RehydratedComponents var2) throws IOException;

        public static abstract class NotSerializable<T extends PTransform<?, ?>>
        implements TransformPayloadTranslator<T> {
            public static NotSerializable<?> forUrn(final String urn) {
                return new NotSerializable<PTransform<?, ?>>(){

                    @Override
                    public String getUrn(PTransform<?, ?> transform) {
                        return urn;
                    }
                };
            }

            @Override
            public final RunnerApi.FunctionSpec translate(AppliedPTransform<?, ?, T> transform, SdkComponents components) throws IOException {
                throw new UnsupportedOperationException(String.format("%s should never be translated", transform.getTransform().getClass().getCanonicalName()));
            }

            @Override
            public final RawPTransform<?, ?> rehydrate(RunnerApi.PTransform protoTransform, RehydratedComponents rehydratedComponents) throws IOException {
                throw new UnsupportedOperationException(String.format("%s.rehydrate should never be called; there is no serialized form", this.getClass().getCanonicalName()));
            }
        }

        public static abstract class WithDefaultRehydration<T extends PTransform<?, ?>>
        implements TransformPayloadTranslator<T> {
            @Override
            public final RawPTransform<?, ?> rehydrate(RunnerApi.PTransform protoTransform, RehydratedComponents rehydratedComponents) throws IOException {
                return UnknownRawPTransform.forSpec(protoTransform.getSpec());
            }
        }
    }
}

