/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct.repackaged.runners.core.construction;

import com.google.auto.service.AutoService;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.beam.runners.direct.repackaged.com.google.protobuf.ByteString;
import org.apache.beam.runners.direct.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.beam.runners.direct.repackaged.javax.annotation.Nullable;
import org.apache.beam.runners.direct.repackaged.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.CombineTranslation;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.Environments;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.PCollectionViewTranslation;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.PTransformTranslation;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.RehydratedComponents;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.SdkComponents;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.TransformPayloadTranslatorRegistrar;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.java.repackaged.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.java.repackaged.com.google.common.base.MoreObjects;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.java.repackaged.com.google.common.base.Preconditions;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.java.repackaged.com.google.common.collect.Iterables;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.java.repackaged.com.google.common.collect.Sets;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.state.StateSpec;
import org.apache.beam.sdk.state.StateSpecs;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.state.TimerSpec;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.ViewFn;
import org.apache.beam.sdk.transforms.reflect.DoFnSignature;
import org.apache.beam.sdk.transforms.reflect.DoFnSignatures;
import org.apache.beam.sdk.transforms.windowing.WindowMappingFn;
import org.apache.beam.sdk.util.DoFnAndMainOutput;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;

public class ParDoTranslation {
    public static final String CUSTOM_JAVA_DO_FN_URN = "urn:beam:dofn:javasdk:0.1";
    public static final String CUSTOM_JAVA_VIEW_FN_URN = "urn:beam:viewfn:javasdk:0.1";
    public static final String CUSTOM_JAVA_WINDOW_MAPPING_FN_URN = "urn:beam:windowmappingfn:javasdk:0.1";

    public static RunnerApi.ParDoPayload translateParDo(final ParDo.MultiOutput<?, ?> parDo, SdkComponents components) throws IOException {
        final DoFn doFn = parDo.getFn();
        final DoFnSignature signature = DoFnSignatures.getSignature(doFn.getClass());
        return ParDoTranslation.payloadForParDoLike(new ParDoLike(){

            @Override
            public RunnerApi.SdkFunctionSpec translateDoFn(SdkComponents newComponents) {
                return ParDoTranslation.translateDoFn(parDo.getFn(), parDo.getMainOutputTag(), newComponents);
            }

            @Override
            public List<RunnerApi.Parameter> translateParameters() {
                ArrayList<RunnerApi.Parameter> parameters = new ArrayList<RunnerApi.Parameter>();
                for (DoFnSignature.Parameter parameter : signature.processElement().extraParameters()) {
                    RunnerApi.Parameter protoParameter = ParDoTranslation.translateParameter(parameter);
                    if (protoParameter == null) continue;
                    parameters.add(protoParameter);
                }
                return parameters;
            }

            @Override
            public Map<String, RunnerApi.SideInput> translateSideInputs(SdkComponents components) {
                HashMap<String, RunnerApi.SideInput> sideInputs = new HashMap<String, RunnerApi.SideInput>();
                for (PCollectionView sideInput : parDo.getSideInputs()) {
                    sideInputs.put(sideInput.getTagInternal().getId(), ParDoTranslation.translateView(sideInput, components));
                }
                return sideInputs;
            }

            @Override
            public Map<String, RunnerApi.StateSpec> translateStateSpecs(SdkComponents components) throws IOException {
                HashMap<String, RunnerApi.StateSpec> stateSpecs = new HashMap<String, RunnerApi.StateSpec>();
                for (Map.Entry state : signature.stateDeclarations().entrySet()) {
                    RunnerApi.StateSpec spec = ParDoTranslation.translateStateSpec(DoFnSignatures.getStateSpecOrThrow((DoFnSignature.StateDeclaration)((DoFnSignature.StateDeclaration)state.getValue()), (DoFn)doFn), components);
                    stateSpecs.put((String)state.getKey(), spec);
                }
                return stateSpecs;
            }

            @Override
            public Map<String, RunnerApi.TimerSpec> translateTimerSpecs(SdkComponents newComponents) {
                HashMap<String, RunnerApi.TimerSpec> timerSpecs = new HashMap<String, RunnerApi.TimerSpec>();
                for (Map.Entry timer : signature.timerDeclarations().entrySet()) {
                    RunnerApi.TimerSpec spec = ParDoTranslation.translateTimerSpec(DoFnSignatures.getTimerSpecOrThrow((DoFnSignature.TimerDeclaration)((DoFnSignature.TimerDeclaration)timer.getValue()), (DoFn)doFn));
                    timerSpecs.put((String)timer.getKey(), spec);
                }
                return timerSpecs;
            }

            @Override
            public boolean isSplittable() {
                return signature.processElement().isSplittable();
            }
        }, components);
    }

    public static DoFn<?, ?> getDoFn(RunnerApi.ParDoPayload payload) throws InvalidProtocolBufferException {
        return ParDoTranslation.doFnAndMainOutputTagFromProto(payload.getDoFn()).getDoFn();
    }

    public static DoFn<?, ?> getDoFn(AppliedPTransform<?, ?, ?> application) throws IOException {
        PTransform transform = application.getTransform();
        if (transform instanceof ParDo.MultiOutput) {
            return ((ParDo.MultiOutput)transform).getFn();
        }
        return ParDoTranslation.getDoFn(ParDoTranslation.getParDoPayload(application));
    }

    public static TupleTag<?> getMainOutputTag(RunnerApi.ParDoPayload payload) throws InvalidProtocolBufferException {
        return ParDoTranslation.doFnAndMainOutputTagFromProto(payload.getDoFn()).getMainOutputTag();
    }

    public static TupleTag<?> getMainOutputTag(AppliedPTransform<?, ?, ?> application) throws IOException {
        PTransform transform = application.getTransform();
        if (transform instanceof ParDo.MultiOutput) {
            return ((ParDo.MultiOutput)transform).getMainOutputTag();
        }
        return ParDoTranslation.getMainOutputTag(ParDoTranslation.getParDoPayload(application));
    }

    public static TupleTagList getAdditionalOutputTags(AppliedPTransform<?, ?, ?> application) throws IOException {
        PTransform transform = application.getTransform();
        if (transform instanceof ParDo.MultiOutput) {
            return ((ParDo.MultiOutput)transform).getAdditionalOutputTags();
        }
        RunnerApi.PTransform protoTransform = PTransformTranslation.toProto(application, SdkComponents.create());
        RunnerApi.ParDoPayload payload = RunnerApi.ParDoPayload.parseFrom(protoTransform.getSpec().getPayload());
        TupleTag<?> mainOutputTag = ParDoTranslation.getMainOutputTag(payload);
        Sets.SetView<String> outputTags = Sets.difference(protoTransform.getOutputsMap().keySet(), Collections.singleton(mainOutputTag.getId()));
        ArrayList<TupleTag> additionalOutputTags = new ArrayList<TupleTag>();
        for (String outputTag : outputTags) {
            additionalOutputTags.add(new TupleTag(outputTag));
        }
        return TupleTagList.of(additionalOutputTags);
    }

    public static List<PCollectionView<?>> getSideInputs(AppliedPTransform<?, ?, ?> application) throws IOException {
        PTransform transform = application.getTransform();
        if (transform instanceof ParDo.MultiOutput) {
            return ((ParDo.MultiOutput)transform).getSideInputs();
        }
        SdkComponents sdkComponents = SdkComponents.create();
        RunnerApi.PTransform parDoProto = PTransformTranslation.toProto(application, sdkComponents);
        RunnerApi.ParDoPayload payload = RunnerApi.ParDoPayload.parseFrom(parDoProto.getSpec().getPayload());
        ArrayList views = new ArrayList();
        RehydratedComponents components = RehydratedComponents.forComponents(sdkComponents.toComponents());
        for (Map.Entry<String, RunnerApi.SideInput> sideInputEntry : payload.getSideInputsMap().entrySet()) {
            String sideInputTag = sideInputEntry.getKey();
            RunnerApi.SideInput sideInput = sideInputEntry.getValue();
            PCollection originalPCollection = Preconditions.checkNotNull((PCollection)application.getInputs().get(new TupleTag(sideInputTag)), "no input with tag %s", (Object)sideInputTag);
            views.add(PCollectionViewTranslation.viewFromProto(sideInput, sideInputTag, originalPCollection, parDoProto, components));
        }
        return views;
    }

    public static RunnerApi.PCollection getMainInput(RunnerApi.PTransform ptransform, RunnerApi.Components components) throws IOException {
        Preconditions.checkArgument(ptransform.getSpec().getUrn().equals("urn:beam:transform:pardo:v1"), "Unexpected payload type %s", (Object)ptransform.getSpec().getUrn());
        RunnerApi.ParDoPayload payload = RunnerApi.ParDoPayload.parseFrom(ptransform.getSpec().getPayload());
        String mainInputId = Iterables.getOnlyElement(Sets.difference(ptransform.getInputsMap().keySet(), payload.getSideInputsMap().keySet()));
        return components.getPcollectionsOrThrow(ptransform.getInputsOrThrow(mainInputId));
    }

    public static RunnerApi.StateSpec translateStateSpec(StateSpec<?> stateSpec, final SdkComponents components) throws IOException {
        final RunnerApi.StateSpec.Builder builder = RunnerApi.StateSpec.newBuilder();
        return (RunnerApi.StateSpec)stateSpec.match((StateSpec.Cases)new StateSpec.Cases<RunnerApi.StateSpec>(){

            public RunnerApi.StateSpec dispatchValue(Coder<?> valueCoder) {
                return builder.setValueSpec(RunnerApi.ValueStateSpec.newBuilder().setCoderId(ParDoTranslation.registerCoderOrThrow(components, valueCoder))).build();
            }

            public RunnerApi.StateSpec dispatchBag(Coder<?> elementCoder) {
                return builder.setBagSpec(RunnerApi.BagStateSpec.newBuilder().setElementCoderId(ParDoTranslation.registerCoderOrThrow(components, elementCoder))).build();
            }

            public RunnerApi.StateSpec dispatchCombining(Combine.CombineFn<?, ?, ?> combineFn, Coder<?> accumCoder) {
                return builder.setCombiningSpec(RunnerApi.CombiningStateSpec.newBuilder().setAccumulatorCoderId(ParDoTranslation.registerCoderOrThrow(components, accumCoder)).setCombineFn(CombineTranslation.toProto(combineFn, components))).build();
            }

            public RunnerApi.StateSpec dispatchMap(Coder<?> keyCoder, Coder<?> valueCoder) {
                return builder.setMapSpec(RunnerApi.MapStateSpec.newBuilder().setKeyCoderId(ParDoTranslation.registerCoderOrThrow(components, keyCoder)).setValueCoderId(ParDoTranslation.registerCoderOrThrow(components, valueCoder))).build();
            }

            public RunnerApi.StateSpec dispatchSet(Coder<?> elementCoder) {
                return builder.setSetSpec(RunnerApi.SetStateSpec.newBuilder().setElementCoderId(ParDoTranslation.registerCoderOrThrow(components, elementCoder))).build();
            }
        });
    }

    @VisibleForTesting
    static StateSpec<?> fromProto(RunnerApi.StateSpec stateSpec, RehydratedComponents components) throws IOException {
        switch (stateSpec.getSpecCase()) {
            case VALUE_SPEC: {
                return StateSpecs.value(components.getCoder(stateSpec.getValueSpec().getCoderId()));
            }
            case BAG_SPEC: {
                return StateSpecs.bag(components.getCoder(stateSpec.getBagSpec().getElementCoderId()));
            }
            case COMBINING_SPEC: {
                RunnerApi.FunctionSpec combineFnSpec = stateSpec.getCombiningSpec().getCombineFn().getSpec();
                if (!combineFnSpec.getUrn().equals("urn:beam:combinefn:javasdk:v1")) {
                    throw new UnsupportedOperationException(String.format("Cannot create %s from non-Java %s: %s", StateSpec.class.getSimpleName(), Combine.CombineFn.class.getSimpleName(), combineFnSpec.getUrn()));
                }
                Combine.CombineFn combineFn = (Combine.CombineFn)SerializableUtils.deserializeFromByteArray((byte[])combineFnSpec.getPayload().toByteArray(), (String)Combine.CombineFn.class.getSimpleName());
                return StateSpecs.combining(components.getCoder(stateSpec.getCombiningSpec().getAccumulatorCoderId()), (Combine.CombineFn)combineFn);
            }
            case MAP_SPEC: {
                return StateSpecs.map(components.getCoder(stateSpec.getMapSpec().getKeyCoderId()), components.getCoder(stateSpec.getMapSpec().getValueCoderId()));
            }
            case SET_SPEC: {
                return StateSpecs.set(components.getCoder(stateSpec.getSetSpec().getElementCoderId()));
            }
        }
        throw new IllegalArgumentException(String.format("Unknown %s: %s", RunnerApi.StateSpec.class.getName(), stateSpec));
    }

    private static String registerCoderOrThrow(SdkComponents components, Coder coder) {
        try {
            return components.registerCoder(coder);
        }
        catch (IOException exc) {
            throw new RuntimeException("Failure to register coder", exc);
        }
    }

    public static RunnerApi.TimerSpec translateTimerSpec(TimerSpec timer) {
        return RunnerApi.TimerSpec.newBuilder().setTimeDomain(ParDoTranslation.translateTimeDomain(timer.getTimeDomain())).build();
    }

    private static RunnerApi.TimeDomain.Enum translateTimeDomain(TimeDomain timeDomain) {
        switch (timeDomain) {
            case EVENT_TIME: {
                return RunnerApi.TimeDomain.Enum.EVENT_TIME;
            }
            case PROCESSING_TIME: {
                return RunnerApi.TimeDomain.Enum.PROCESSING_TIME;
            }
            case SYNCHRONIZED_PROCESSING_TIME: {
                return RunnerApi.TimeDomain.Enum.SYNCHRONIZED_PROCESSING_TIME;
            }
        }
        throw new IllegalArgumentException("Unknown time domain");
    }

    public static RunnerApi.SdkFunctionSpec translateDoFn(DoFn<?, ?> fn, TupleTag<?> tag, SdkComponents components) {
        return RunnerApi.SdkFunctionSpec.newBuilder().setEnvironmentId(components.registerEnvironment(Environments.JAVA_SDK_HARNESS_ENVIRONMENT)).setSpec(RunnerApi.FunctionSpec.newBuilder().setUrn(CUSTOM_JAVA_DO_FN_URN).setPayload(ByteString.copyFrom(SerializableUtils.serializeToByteArray((Serializable)DoFnAndMainOutput.of(fn, tag)))).build()).build();
    }

    private static DoFnAndMainOutput doFnAndMainOutputTagFromProto(RunnerApi.SdkFunctionSpec fnSpec) throws InvalidProtocolBufferException {
        Preconditions.checkArgument(fnSpec.getSpec().getUrn().equals(CUSTOM_JAVA_DO_FN_URN), "Expected %s to be %s with URN %s, but URN was %s", (Object)DoFn.class.getSimpleName(), (Object)RunnerApi.FunctionSpec.class.getSimpleName(), (Object)CUSTOM_JAVA_DO_FN_URN, (Object)fnSpec.getSpec().getUrn());
        byte[] serializedFn = fnSpec.getSpec().getPayload().toByteArray();
        return (DoFnAndMainOutput)SerializableUtils.deserializeFromByteArray((byte[])serializedFn, (String)"Custom DoFn And Main Output tag");
    }

    @Nullable
    public static RunnerApi.Parameter translateParameter(DoFnSignature.Parameter parameter) {
        return (RunnerApi.Parameter)parameter.match((DoFnSignature.Parameter.Cases)new DoFnSignature.Parameter.Cases.WithDefault<RunnerApi.Parameter>(){

            public RunnerApi.Parameter dispatch(DoFnSignature.Parameter.WindowParameter p) {
                return RunnerApi.Parameter.newBuilder().setType(RunnerApi.Parameter.Type.Enum.WINDOW).build();
            }

            public RunnerApi.Parameter dispatch(DoFnSignature.Parameter.RestrictionTrackerParameter p) {
                return RunnerApi.Parameter.newBuilder().setType(RunnerApi.Parameter.Type.Enum.RESTRICTION_TRACKER).build();
            }

            @Nullable
            protected RunnerApi.Parameter dispatchDefault(DoFnSignature.Parameter p) {
                return null;
            }
        });
    }

    public static RunnerApi.SideInput translateView(PCollectionView<?> view, SdkComponents components) {
        RunnerApi.SideInput.Builder builder = RunnerApi.SideInput.newBuilder();
        builder.setAccessPattern(RunnerApi.FunctionSpec.newBuilder().setUrn(view.getViewFn().getMaterialization().getUrn()).build());
        builder.setViewFn(ParDoTranslation.translateViewFn(view.getViewFn(), components));
        builder.setWindowMappingFn(ParDoTranslation.translateWindowMappingFn(view.getWindowMappingFn(), components));
        return builder.build();
    }

    private static RunnerApi.SdkFunctionSpec translateViewFn(ViewFn<?, ?> viewFn, SdkComponents components) {
        return RunnerApi.SdkFunctionSpec.newBuilder().setEnvironmentId(components.registerEnvironment(Environments.JAVA_SDK_HARNESS_ENVIRONMENT)).setSpec(RunnerApi.FunctionSpec.newBuilder().setUrn(CUSTOM_JAVA_VIEW_FN_URN).setPayload(ByteString.copyFrom(SerializableUtils.serializeToByteArray(viewFn))).build()).build();
    }

    private static <T> RunnerApi.ParDoPayload getParDoPayload(AppliedPTransform<?, ?, ?> transform) throws IOException {
        RunnerApi.PTransform parDoPTransform = PTransformTranslation.toProto(transform, Collections.emptyList(), SdkComponents.create());
        return RunnerApi.ParDoPayload.parseFrom(parDoPTransform.getSpec().getPayload());
    }

    public static boolean usesStateOrTimers(AppliedPTransform<?, ?, ?> transform) throws IOException {
        RunnerApi.ParDoPayload payload = ParDoTranslation.getParDoPayload(transform);
        return payload.getStateSpecsCount() > 0 || payload.getTimerSpecsCount() > 0;
    }

    public static boolean isSplittable(AppliedPTransform<?, ?, ?> transform) throws IOException {
        RunnerApi.ParDoPayload payload = ParDoTranslation.getParDoPayload(transform);
        return payload.getSplittable();
    }

    private static RunnerApi.SdkFunctionSpec translateWindowMappingFn(WindowMappingFn<?> windowMappingFn, SdkComponents components) {
        return RunnerApi.SdkFunctionSpec.newBuilder().setEnvironmentId(components.registerEnvironment(Environments.JAVA_SDK_HARNESS_ENVIRONMENT)).setSpec(RunnerApi.FunctionSpec.newBuilder().setUrn(CUSTOM_JAVA_WINDOW_MAPPING_FN_URN).setPayload(ByteString.copyFrom(SerializableUtils.serializeToByteArray(windowMappingFn))).build()).build();
    }

    public static RunnerApi.ParDoPayload payloadForParDoLike(ParDoLike parDo, SdkComponents components) throws IOException {
        return RunnerApi.ParDoPayload.newBuilder().setDoFn(parDo.translateDoFn(components)).addAllParameters(parDo.translateParameters()).putAllStateSpecs(parDo.translateStateSpecs(components)).putAllTimerSpecs(parDo.translateTimerSpecs(components)).putAllSideInputs(parDo.translateSideInputs(components)).setSplittable(parDo.isSplittable()).build();
    }

    public static interface ParDoLike {
        public RunnerApi.SdkFunctionSpec translateDoFn(SdkComponents var1);

        public List<RunnerApi.Parameter> translateParameters();

        public Map<String, RunnerApi.SideInput> translateSideInputs(SdkComponents var1);

        public Map<String, RunnerApi.StateSpec> translateStateSpecs(SdkComponents var1) throws IOException;

        public Map<String, RunnerApi.TimerSpec> translateTimerSpecs(SdkComponents var1);

        public boolean isSplittable();
    }

    static class RawParDo<InputT, OutputT>
    extends PTransformTranslation.RawPTransform<PCollection<InputT>, PCollection<OutputT>>
    implements ParDoLike {
        private final RunnerApi.PTransform protoTransform;
        private final transient RehydratedComponents rehydratedComponents;
        private final RunnerApi.FunctionSpec spec;
        private final RunnerApi.ParDoPayload payload;

        public RawParDo(RunnerApi.PTransform protoTransform, RehydratedComponents rehydratedComponents) throws IOException {
            this.rehydratedComponents = rehydratedComponents;
            this.protoTransform = protoTransform;
            this.spec = protoTransform.getSpec();
            this.payload = RunnerApi.ParDoPayload.parseFrom(this.spec.getPayload());
        }

        @Override
        public RunnerApi.FunctionSpec getSpec() {
            return this.spec;
        }

        @Override
        public RunnerApi.FunctionSpec migrate(SdkComponents components) throws IOException {
            return RunnerApi.FunctionSpec.newBuilder().setUrn("urn:beam:transform:pardo:v1").setPayload(ParDoTranslation.payloadForParDoLike(this, components).toByteString()).build();
        }

        public Map<TupleTag<?>, PValue> getAdditionalInputs() {
            HashMap additionalInputs = new HashMap();
            for (Map.Entry<String, RunnerApi.SideInput> sideInputEntry : this.payload.getSideInputsMap().entrySet()) {
                try {
                    additionalInputs.put((TupleTag<?>)new TupleTag(sideInputEntry.getKey()), (PValue)this.rehydratedComponents.getPCollection(this.protoTransform.getInputsOrThrow(sideInputEntry.getKey())));
                }
                catch (IOException exc) {
                    throw new IllegalStateException(String.format("Could not find input with name %s for %s transform", sideInputEntry.getKey(), ParDo.class.getSimpleName()));
                }
            }
            return additionalInputs;
        }

        @Override
        public RunnerApi.SdkFunctionSpec translateDoFn(SdkComponents newComponents) {
            RunnerApi.SdkFunctionSpec sdkFnSpec = this.payload.getDoFn();
            return sdkFnSpec.toBuilder().setEnvironmentId(newComponents.registerEnvironment(this.rehydratedComponents.getEnvironment(sdkFnSpec.getEnvironmentId()))).build();
        }

        @Override
        public List<RunnerApi.Parameter> translateParameters() {
            return MoreObjects.firstNonNull(this.payload.getParametersList(), Collections.emptyList());
        }

        @Override
        public Map<String, RunnerApi.SideInput> translateSideInputs(SdkComponents components) {
            return MoreObjects.firstNonNull(this.payload.getSideInputsMap(), Collections.emptyMap());
        }

        @Override
        public Map<String, RunnerApi.StateSpec> translateStateSpecs(SdkComponents components) {
            return MoreObjects.firstNonNull(this.payload.getStateSpecsMap(), Collections.emptyMap());
        }

        @Override
        public Map<String, RunnerApi.TimerSpec> translateTimerSpecs(SdkComponents newComponents) {
            return MoreObjects.firstNonNull(this.payload.getTimerSpecsMap(), Collections.emptyMap());
        }

        @Override
        public boolean isSplittable() {
            return this.payload.getSplittable();
        }
    }

    public static class ParDoPayloadTranslator
    implements PTransformTranslation.TransformPayloadTranslator<ParDo.MultiOutput<?, ?>> {
        public static PTransformTranslation.TransformPayloadTranslator create() {
            return new ParDoPayloadTranslator();
        }

        private ParDoPayloadTranslator() {
        }

        @Override
        public String getUrn(ParDo.MultiOutput<?, ?> transform) {
            return "urn:beam:transform:pardo:v1";
        }

        @Override
        public RunnerApi.FunctionSpec translate(AppliedPTransform<?, ?, ParDo.MultiOutput<?, ?>> transform, SdkComponents components) throws IOException {
            RunnerApi.ParDoPayload payload = ParDoTranslation.translateParDo((ParDo.MultiOutput)transform.getTransform(), components);
            return RunnerApi.FunctionSpec.newBuilder().setUrn("urn:beam:transform:pardo:v1").setPayload(payload.toByteString()).build();
        }

        @Override
        public PTransformTranslation.RawPTransform<?, ?> rehydrate(RunnerApi.PTransform protoTransform, RehydratedComponents rehydratedComponents) throws IOException {
            return new RawParDo(protoTransform, rehydratedComponents);
        }

        @AutoService(value=TransformPayloadTranslatorRegistrar.class)
        public static class Registrar
        implements TransformPayloadTranslatorRegistrar {
            @Override
            public Map<? extends Class<? extends PTransform>, ? extends PTransformTranslation.TransformPayloadTranslator> getTransformPayloadTranslators() {
                return Collections.singletonMap(ParDo.MultiOutput.class, new ParDoPayloadTranslator());
            }

            @Override
            public Map<String, ? extends PTransformTranslation.TransformPayloadTranslator> getTransformRehydrators() {
                return Collections.singletonMap("urn:beam:transform:pardo:v1", new ParDoPayloadTranslator());
            }
        }
    }
}

