/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.construction.graph;

import com.google.auto.value.AutoValue;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.repackaged.direct_java.runners.core.construction.SyntheticComponents;
import org.apache.beam.repackaged.direct_java.runners.core.construction.graph.AutoValue_FusedPipeline;
import org.apache.beam.repackaged.direct_java.runners.core.construction.graph.ExecutableStage;
import org.apache.beam.repackaged.direct_java.runners.core.construction.graph.PipelineNode;
import org.apache.beam.repackaged.direct_java.runners.core.construction.graph.PipelineValidator;
import org.apache.beam.repackaged.direct_java.runners.core.construction.graph.QueryablePipeline;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Sets;

@AutoValue
public abstract class FusedPipeline {
    static FusedPipeline of(RunnerApi.Components components, Set<ExecutableStage> environmentalStages, Set<PipelineNode.PTransformNode> runnerStages, Set<String> requirements) {
        return new AutoValue_FusedPipeline(components, environmentalStages, runnerStages, requirements);
    }

    abstract RunnerApi.Components getComponents();

    public abstract Set<ExecutableStage> getFusedStages();

    public abstract Set<PipelineNode.PTransformNode> getRunnerExecutedTransforms();

    public abstract Set<String> getRequirements();

    public RunnerApi.Pipeline toPipeline() {
        Map<String, RunnerApi.PTransform> executableStageTransforms = this.getEnvironmentExecutedTransforms();
        Sets.SetView executableTransformIds = Sets.union(executableStageTransforms.keySet(), this.getRunnerExecutedTransforms().stream().map(PipelineNode.PTransformNode::getId).collect(Collectors.toSet()));
        RunnerApi.Components fusedComponents = this.getComponents().toBuilder().putAllTransforms(executableStageTransforms).build();
        List rootTransformIds = StreamSupport.stream(QueryablePipeline.forTransforms((Collection<String>)executableTransformIds, fusedComponents).getTopologicallyOrderedTransforms().spliterator(), false).map(PipelineNode.PTransformNode::getId).collect(Collectors.toList());
        RunnerApi.Pipeline res = RunnerApi.Pipeline.newBuilder().setComponents(fusedComponents).addAllRootTransformIds(rootTransformIds).addAllRequirements(this.getRequirements()).build();
        PipelineValidator.validate(res);
        return res;
    }

    private Map<String, RunnerApi.PTransform> getEnvironmentExecutedTransforms() {
        HashMap<String, RunnerApi.PTransform> topLevelTransforms = new HashMap<String, RunnerApi.PTransform>();
        for (ExecutableStage stage : this.getFusedStages()) {
            String baseName = String.format("%s/%s", stage.getInputPCollection().getPCollection().getUniqueName(), stage.getEnvironment().getUrn());
            Sets.SetView usedNames = Sets.union(topLevelTransforms.keySet(), this.getComponents().getTransformsMap().keySet());
            String uniqueId = SyntheticComponents.uniqueId(baseName, ((Set)usedNames)::contains);
            topLevelTransforms.put(uniqueId, stage.toPTransform(uniqueId));
        }
        return topLevelTransforms;
    }
}

