/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.sdk.fn.splittabledofn;

import javax.annotation.concurrent.ThreadSafe;
import org.apache.beam.sdk.transforms.splittabledofn.ManualWatermarkEstimator;
import org.apache.beam.sdk.transforms.splittabledofn.TimestampObservingWatermarkEstimator;
import org.apache.beam.sdk.transforms.splittabledofn.WatermarkEstimator;
import org.apache.beam.sdk.values.KV;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

public class WatermarkEstimators {
    public static <WatermarkEstimatorStateT> @UnknownKeyFor @NonNull @Initialized WatermarkAndStateObserver<WatermarkEstimatorStateT> threadSafe(@UnknownKeyFor @NonNull @Initialized WatermarkEstimator<WatermarkEstimatorStateT> watermarkEstimator) {
        if (watermarkEstimator instanceof TimestampObservingWatermarkEstimator) {
            return new ThreadSafeTimestampObservingWatermarkEstimator<WatermarkEstimatorStateT>(watermarkEstimator);
        }
        if (watermarkEstimator instanceof ManualWatermarkEstimator) {
            return new ThreadSafeManualWatermarkEstimator<WatermarkEstimatorStateT>(watermarkEstimator);
        }
        return new ThreadSafeWatermarkEstimator<WatermarkEstimatorStateT>(watermarkEstimator);
    }

    @ThreadSafe
    private static class ThreadSafeManualWatermarkEstimator<@UnknownKeyFor WatermarkEstimatorStateT>
    extends ThreadSafeWatermarkEstimator<WatermarkEstimatorStateT>
    implements ManualWatermarkEstimator<WatermarkEstimatorStateT> {
        ThreadSafeManualWatermarkEstimator(@UnknownKeyFor @NonNull @Initialized WatermarkEstimator<WatermarkEstimatorStateT> watermarkEstimator) {
            super(watermarkEstimator);
        }

        public synchronized void setWatermark(@UnknownKeyFor @NonNull @Initialized Instant watermark) {
            ((ManualWatermarkEstimator)this.watermarkEstimator).setWatermark(watermark);
        }
    }

    @ThreadSafe
    private static class ThreadSafeTimestampObservingWatermarkEstimator<@UnknownKeyFor WatermarkEstimatorStateT>
    extends ThreadSafeWatermarkEstimator<WatermarkEstimatorStateT>
    implements TimestampObservingWatermarkEstimator<WatermarkEstimatorStateT> {
        ThreadSafeTimestampObservingWatermarkEstimator(@UnknownKeyFor @NonNull @Initialized WatermarkEstimator<WatermarkEstimatorStateT> watermarkEstimator) {
            super(watermarkEstimator);
        }

        public synchronized void observeTimestamp(@UnknownKeyFor @NonNull @Initialized Instant timestamp) {
            ((TimestampObservingWatermarkEstimator)this.watermarkEstimator).observeTimestamp(timestamp);
        }
    }

    @ThreadSafe
    private static class ThreadSafeWatermarkEstimator<@UnknownKeyFor WatermarkEstimatorStateT>
    implements WatermarkAndStateObserver<WatermarkEstimatorStateT> {
        protected final @UnknownKeyFor @NonNull @Initialized WatermarkEstimator<WatermarkEstimatorStateT> watermarkEstimator;

        ThreadSafeWatermarkEstimator(@UnknownKeyFor @NonNull @Initialized WatermarkEstimator<WatermarkEstimatorStateT> watermarkEstimator) {
            this.watermarkEstimator = watermarkEstimator;
        }

        public synchronized @UnknownKeyFor @NonNull @Initialized Instant currentWatermark() {
            return this.watermarkEstimator.currentWatermark();
        }

        public synchronized WatermarkEstimatorStateT getState() {
            return (WatermarkEstimatorStateT)this.watermarkEstimator.getState();
        }

        @Override
        public synchronized @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Instant, WatermarkEstimatorStateT> getWatermarkAndState() {
            return KV.of((Object)this.watermarkEstimator.currentWatermark(), (Object)this.watermarkEstimator.getState());
        }
    }

    public static interface WatermarkAndStateObserver<@UnknownKeyFor WatermarkEstimatorStateT>
    extends WatermarkEstimator<WatermarkEstimatorStateT> {
        public @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Instant, WatermarkEstimatorStateT> getWatermarkAndState();
    }
}

