/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.sdk.fn.stream;

import java.util.concurrent.ExecutorService;
import org.apache.beam.repackaged.direct_java.sdk.fn.stream.AdvancingPhaser;
import org.apache.beam.repackaged.direct_java.sdk.fn.stream.BufferingStreamObserver;
import org.apache.beam.repackaged.direct_java.sdk.fn.stream.DirectStreamObserver;
import org.apache.beam.repackaged.direct_java.sdk.fn.stream.ForwardingClientResponseObserver;
import org.apache.beam.vendor.grpc.v1p54p0.io.grpc.stub.CallStreamObserver;
import org.apache.beam.vendor.grpc.v1p54p0.io.grpc.stub.StreamObserver;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public abstract class OutboundObserverFactory {
    public static @UnknownKeyFor @NonNull @Initialized OutboundObserverFactory clientBuffered(@UnknownKeyFor @NonNull @Initialized ExecutorService executorService) {
        return new Buffered(executorService, 64);
    }

    public static @UnknownKeyFor @NonNull @Initialized OutboundObserverFactory clientBuffered(@UnknownKeyFor @NonNull @Initialized ExecutorService executorService, @UnknownKeyFor @NonNull @Initialized int bufferSize) {
        return new Buffered(executorService, bufferSize);
    }

    public static @UnknownKeyFor @NonNull @Initialized OutboundObserverFactory clientDirect() {
        return new DirectClient();
    }

    public static @UnknownKeyFor @NonNull @Initialized OutboundObserverFactory serverDirect() {
        return new DirectServer();
    }

    public static @UnknownKeyFor @NonNull @Initialized OutboundObserverFactory trivial() {
        return new Trivial();
    }

    public abstract <ReqT, RespT> @UnknownKeyFor @NonNull @Initialized StreamObserver<RespT> outboundObserverFor(@UnknownKeyFor @NonNull @Initialized BasicFactory<ReqT, RespT> var1, @UnknownKeyFor @NonNull @Initialized StreamObserver<ReqT> var2);

    private static class Trivial
    extends OutboundObserverFactory {
        private Trivial() {
        }

        @Override
        public <ReqT, RespT> @UnknownKeyFor @NonNull @Initialized StreamObserver<RespT> outboundObserverFor(@UnknownKeyFor @NonNull @Initialized BasicFactory<ReqT, RespT> baseOutboundObserverFactory, @UnknownKeyFor @NonNull @Initialized StreamObserver<ReqT> inboundObserver) {
            return baseOutboundObserverFactory.outboundObserverFor(inboundObserver);
        }
    }

    private static class Buffered
    extends OutboundObserverFactory {
        private static final @UnknownKeyFor @NonNull @Initialized int DEFAULT_BUFFER_SIZE = 64;
        private final @UnknownKeyFor @NonNull @Initialized ExecutorService executorService;
        private final @UnknownKeyFor @NonNull @Initialized int bufferSize;

        private Buffered(@UnknownKeyFor @NonNull @Initialized ExecutorService executorService, @UnknownKeyFor @NonNull @Initialized int bufferSize) {
            this.executorService = executorService;
            this.bufferSize = bufferSize;
        }

        @Override
        public <ReqT, RespT> @UnknownKeyFor @NonNull @Initialized StreamObserver<RespT> outboundObserverFor(@UnknownKeyFor @NonNull @Initialized BasicFactory<ReqT, RespT> baseOutboundObserverFactory, @UnknownKeyFor @NonNull @Initialized StreamObserver<ReqT> inboundObserver) {
            AdvancingPhaser phaser = new AdvancingPhaser(1);
            inboundObserver = ForwardingClientResponseObserver.create(inboundObserver, phaser::arrive);
            CallStreamObserver outboundObserver = (CallStreamObserver)baseOutboundObserverFactory.outboundObserverFor((StreamObserver<ReqT>)inboundObserver);
            return new BufferingStreamObserver(phaser, outboundObserver, this.executorService, this.bufferSize);
        }
    }

    private static class DirectServer
    extends OutboundObserverFactory {
        private DirectServer() {
        }

        @Override
        public <ReqT, RespT> @UnknownKeyFor @NonNull @Initialized StreamObserver<RespT> outboundObserverFor(@UnknownKeyFor @NonNull @Initialized BasicFactory<ReqT, RespT> baseOutboundObserverFactory, @UnknownKeyFor @NonNull @Initialized StreamObserver<ReqT> inboundObserver) {
            AdvancingPhaser phaser = new AdvancingPhaser(1);
            CallStreamObserver outboundObserver = (CallStreamObserver)baseOutboundObserverFactory.outboundObserverFor(inboundObserver);
            outboundObserver.setOnReadyHandler(phaser::arrive);
            return new DirectStreamObserver(phaser, outboundObserver);
        }
    }

    private static class DirectClient
    extends OutboundObserverFactory {
        private DirectClient() {
        }

        @Override
        public <ReqT, RespT> @UnknownKeyFor @NonNull @Initialized StreamObserver<RespT> outboundObserverFor(@UnknownKeyFor @NonNull @Initialized BasicFactory<ReqT, RespT> baseOutboundObserverFactory, @UnknownKeyFor @NonNull @Initialized StreamObserver<ReqT> inboundObserver) {
            AdvancingPhaser phaser = new AdvancingPhaser(1);
            inboundObserver = ForwardingClientResponseObserver.create(inboundObserver, phaser::arrive);
            CallStreamObserver outboundObserver = (CallStreamObserver)baseOutboundObserverFactory.outboundObserverFor((StreamObserver<ReqT>)inboundObserver);
            return new DirectStreamObserver(phaser, outboundObserver);
        }
    }

    @FunctionalInterface
    public static interface BasicFactory<@UnknownKeyFor ReqT, @UnknownKeyFor RespT> {
        public @UnknownKeyFor @NonNull @Initialized StreamObserver<RespT> outboundObserverFor(@UnknownKeyFor @NonNull @Initialized StreamObserver<ReqT> var1);
    }
}

