/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.io.grpc;

import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.beam.repackaged.beam_runners_direct_java.com.google.common.base.Preconditions;

public final class EquivalentAddressGroup {
    private final List<SocketAddress> addrs;
    private final int hashCode;

    public EquivalentAddressGroup(List<SocketAddress> addrs) {
        Preconditions.checkArgument(!addrs.isEmpty(), "addrs is empty");
        this.addrs = Collections.unmodifiableList(new ArrayList<SocketAddress>(addrs));
        this.hashCode = this.addrs.hashCode();
    }

    public EquivalentAddressGroup(SocketAddress addr) {
        this.addrs = Collections.singletonList(addr);
        this.hashCode = this.addrs.hashCode();
    }

    public List<SocketAddress> getAddresses() {
        return this.addrs;
    }

    public String toString() {
        return this.addrs.toString();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object other) {
        if (!(other instanceof EquivalentAddressGroup)) {
            return false;
        }
        EquivalentAddressGroup that = (EquivalentAddressGroup)other;
        if (this.addrs.size() != that.addrs.size()) {
            return false;
        }
        for (int i = 0; i < this.addrs.size(); ++i) {
            if (this.addrs.get(i).equals(that.addrs.get(i))) continue;
            return false;
        }
        return true;
    }
}

