/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.io.grpc;

import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.beam.repackaged.beam_runners_direct_java.com.google.common.base.Preconditions;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.Attributes;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.CallOptions;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.ConnectivityStateInfo;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.EquivalentAddressGroup;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.ManagedChannel;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.Metadata;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.MethodDescriptor;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.NameResolver;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.ResolvedServerInfoGroup;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.Status;

@NotThreadSafe
public abstract class LoadBalancer {
    public abstract void handleResolvedAddresses(List<ResolvedServerInfoGroup> var1, Attributes var2);

    public abstract void handleNameResolutionError(Status var1);

    public abstract void handleSubchannelState(Subchannel var1, ConnectivityStateInfo var2);

    public abstract void shutdown();

    @ThreadSafe
    public static abstract class Factory {
        public abstract LoadBalancer newLoadBalancer(Helper var1);
    }

    @ThreadSafe
    public static abstract class Subchannel {
        public abstract void shutdown();

        public abstract void requestConnection();

        public abstract EquivalentAddressGroup getAddresses();

        public abstract Attributes getAttributes();
    }

    @ThreadSafe
    public static abstract class Helper {
        public abstract Subchannel createSubchannel(EquivalentAddressGroup var1, Attributes var2);

        public abstract ManagedChannel createOobChannel(EquivalentAddressGroup var1, String var2);

        public abstract void updatePicker(SubchannelPicker var1);

        public abstract void runSerialized(Runnable var1);

        public abstract NameResolver.Factory getNameResolverFactory();

        public abstract String getAuthority();
    }

    @Immutable
    public static final class PickResult {
        private static final PickResult NO_RESULT = new PickResult(null, Status.OK);
        @Nullable
        private final Subchannel subchannel;
        private final Status status;

        private PickResult(@Nullable Subchannel subchannel, Status status) {
            this.subchannel = subchannel;
            this.status = Preconditions.checkNotNull(status, "status");
        }

        public static PickResult withSubchannel(Subchannel subchannel) {
            return new PickResult(Preconditions.checkNotNull(subchannel, "subchannel"), Status.OK);
        }

        public static PickResult withError(Status error) {
            Preconditions.checkArgument(!error.isOk(), "error status shouldn't be OK");
            return new PickResult(null, error);
        }

        public static PickResult withNoResult() {
            return NO_RESULT;
        }

        @Nullable
        public Subchannel getSubchannel() {
            return this.subchannel;
        }

        public Status getStatus() {
            return this.status;
        }

        public String toString() {
            return "[subchannel=" + this.subchannel + " status=" + this.status + "]";
        }
    }

    public static abstract class PickSubchannelArgs {
        public abstract CallOptions getCallOptions();

        public abstract Metadata getHeaders();

        public abstract MethodDescriptor<?, ?> getMethodDescriptor();
    }

    @ThreadSafe
    public static abstract class SubchannelPicker {
        @Deprecated
        public PickResult pickSubchannel(Attributes affinity, Metadata headers) {
            throw new UnsupportedOperationException();
        }

        public PickResult pickSubchannel(PickSubchannelArgs args) {
            return this.pickSubchannel(args.getCallOptions().getAffinity(), args.getHeaders());
        }
    }
}

