/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.io.grpc;

import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.apache.beam.repackaged.beam_runners_direct_java.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.repackaged.beam_runners_direct_java.com.google.common.base.Preconditions;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.Attributes;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.ConnectivityState;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.ConnectivityStateInfo;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.EquivalentAddressGroup;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.LoadBalancer;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.ResolvedServerInfo;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.ResolvedServerInfoGroup;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.Status;

public final class PickFirstBalancerFactory
extends LoadBalancer.Factory {
    private static final PickFirstBalancerFactory INSTANCE = new PickFirstBalancerFactory();

    private PickFirstBalancerFactory() {
    }

    public static PickFirstBalancerFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return new PickFirstBalancer(helper);
    }

    @VisibleForTesting
    static final class Picker
    extends LoadBalancer.SubchannelPicker {
        private final LoadBalancer.PickResult result;

        Picker(LoadBalancer.PickResult result) {
            this.result = Preconditions.checkNotNull(result, "result");
        }

        @Override
        public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
            return this.result;
        }
    }

    @VisibleForTesting
    static final class PickFirstBalancer
    extends LoadBalancer {
        private final LoadBalancer.Helper helper;
        private LoadBalancer.Subchannel subchannel;

        PickFirstBalancer(LoadBalancer.Helper helper) {
            this.helper = Preconditions.checkNotNull(helper, "helper");
        }

        @Override
        public void handleResolvedAddresses(List<ResolvedServerInfoGroup> servers, Attributes attributes) {
            EquivalentAddressGroup newEag = PickFirstBalancer.flattenResolvedServerInfoGroupsIntoEquivalentAddressGroup(servers);
            if (this.subchannel == null || !newEag.equals(this.subchannel.getAddresses())) {
                if (this.subchannel != null) {
                    this.subchannel.shutdown();
                }
                this.subchannel = this.helper.createSubchannel(newEag, Attributes.EMPTY);
                this.helper.updatePicker(new Picker(LoadBalancer.PickResult.withSubchannel(this.subchannel)));
            }
        }

        @Override
        public void handleNameResolutionError(Status error) {
            if (this.subchannel != null) {
                this.subchannel.shutdown();
                this.subchannel = null;
            }
            this.helper.updatePicker(new Picker(LoadBalancer.PickResult.withError(error)));
        }

        @Override
        public void handleSubchannelState(LoadBalancer.Subchannel subchannel, ConnectivityStateInfo stateInfo) {
            LoadBalancer.PickResult pickResult;
            ConnectivityState currentState = stateInfo.getState();
            if (subchannel != this.subchannel || currentState == ConnectivityState.SHUTDOWN) {
                return;
            }
            switch (currentState) {
                case CONNECTING: {
                    pickResult = LoadBalancer.PickResult.withNoResult();
                    break;
                }
                case READY: 
                case IDLE: {
                    pickResult = LoadBalancer.PickResult.withSubchannel(subchannel);
                    break;
                }
                case TRANSIENT_FAILURE: {
                    pickResult = LoadBalancer.PickResult.withError(stateInfo.getStatus());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported state:" + (Object)((Object)currentState));
                }
            }
            this.helper.updatePicker(new Picker(pickResult));
        }

        @Override
        public void shutdown() {
            if (this.subchannel != null) {
                this.subchannel.shutdown();
            }
        }

        private static EquivalentAddressGroup flattenResolvedServerInfoGroupsIntoEquivalentAddressGroup(List<ResolvedServerInfoGroup> groupList) {
            ArrayList<SocketAddress> addrs = new ArrayList<SocketAddress>();
            for (ResolvedServerInfoGroup group : groupList) {
                for (ResolvedServerInfo srv : group.getResolvedServerInfoList()) {
                    addrs.add(srv.getAddress());
                }
            }
            return new EquivalentAddressGroup(addrs);
        }
    }
}

