/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.io.grpc;

import java.net.SocketAddress;
import javax.annotation.concurrent.Immutable;
import org.apache.beam.repackaged.beam_runners_direct_java.com.google.common.base.Objects;
import org.apache.beam.repackaged.beam_runners_direct_java.com.google.common.base.Preconditions;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.Attributes;

@Immutable
public final class ResolvedServerInfo {
    private final SocketAddress address;
    private final Attributes attributes;

    public ResolvedServerInfo(SocketAddress address) {
        this(address, Attributes.EMPTY);
    }

    public ResolvedServerInfo(SocketAddress address, Attributes attributes) {
        this.address = Preconditions.checkNotNull(address);
        this.attributes = Preconditions.checkNotNull(attributes);
    }

    public SocketAddress getAddress() {
        return this.address;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public String toString() {
        return "[address=" + this.address + ", attrs=" + this.attributes + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResolvedServerInfo that = (ResolvedServerInfo)o;
        return Objects.equal(this.address, that.address) && Objects.equal(this.attributes, that.attributes);
    }

    public int hashCode() {
        return Objects.hashCode(this.address, this.attributes);
    }
}

