/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.io.grpc;

import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import org.apache.beam.repackaged.beam_runners_direct_java.com.google.common.base.Objects;
import org.apache.beam.repackaged.beam_runners_direct_java.com.google.common.base.Preconditions;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.Attributes;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.EquivalentAddressGroup;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.ResolvedServerInfo;

@Immutable
public final class ResolvedServerInfoGroup {
    private final List<ResolvedServerInfo> resolvedServerInfoList;
    private final Attributes attributes;

    private ResolvedServerInfoGroup(List<ResolvedServerInfo> resolvedServerInfoList, Attributes attributes) {
        Preconditions.checkArgument(!resolvedServerInfoList.isEmpty(), "empty server list");
        this.resolvedServerInfoList = Collections.unmodifiableList(new ArrayList<ResolvedServerInfo>(resolvedServerInfoList));
        this.attributes = Preconditions.checkNotNull(attributes, "attributes");
    }

    public List<ResolvedServerInfo> getResolvedServerInfoList() {
        return this.resolvedServerInfoList;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public EquivalentAddressGroup toEquivalentAddressGroup() {
        ArrayList<SocketAddress> addrs = new ArrayList<SocketAddress>(this.resolvedServerInfoList.size());
        for (ResolvedServerInfo resolvedServerInfo : this.resolvedServerInfoList) {
            addrs.add(resolvedServerInfo.getAddress());
        }
        return new EquivalentAddressGroup(addrs);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Attributes attributes) {
        return new Builder(attributes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResolvedServerInfoGroup that = (ResolvedServerInfoGroup)o;
        return Objects.equal(this.resolvedServerInfoList, that.resolvedServerInfoList) && Objects.equal(this.attributes, that.attributes);
    }

    public int hashCode() {
        return Objects.hashCode(this.resolvedServerInfoList, this.attributes);
    }

    public String toString() {
        return "[servers=" + this.resolvedServerInfoList + ", attrs=" + this.attributes + "]";
    }

    public static final class Builder {
        private final List<ResolvedServerInfo> group = new ArrayList<ResolvedServerInfo>();
        private final Attributes attributes;

        public Builder(Attributes attributes) {
            this.attributes = attributes;
        }

        public Builder() {
            this(Attributes.EMPTY);
        }

        public Builder add(ResolvedServerInfo resolvedServerInfo) {
            this.group.add(resolvedServerInfo);
            return this;
        }

        public Builder addAll(Collection<ResolvedServerInfo> resolvedServerInfo) {
            this.group.addAll(resolvedServerInfo);
            return this;
        }

        public ResolvedServerInfoGroup build() {
            return new ResolvedServerInfoGroup(this.group, this.attributes);
        }
    }
}

