/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.inprocess;

import com.google.instrumentation.stats.StatsContextFactory;
import java.net.SocketAddress;
import org.apache.beam.repackaged.beam_runners_direct_java.com.google.common.base.Preconditions;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.inprocess.InProcessSocketAddress;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.inprocess.InProcessTransport;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal.AbstractManagedChannelImplBuilder;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal.ClientTransportFactory;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal.ConnectionClientTransport;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal.NoopStatsContextFactory;

public class InProcessChannelBuilder
extends AbstractManagedChannelImplBuilder<InProcessChannelBuilder> {
    private final String name;

    public static InProcessChannelBuilder forName(String name) {
        return new InProcessChannelBuilder(name);
    }

    private InProcessChannelBuilder(String name) {
        super(new InProcessSocketAddress(name), "localhost");
        this.name = Preconditions.checkNotNull(name, "name");
        super.statsContextFactory(NoopStatsContextFactory.INSTANCE);
    }

    @Override
    public final InProcessChannelBuilder maxInboundMessageSize(int max) {
        return (InProcessChannelBuilder)super.maxInboundMessageSize(max);
    }

    @Override
    public InProcessChannelBuilder usePlaintext(boolean skipNegotiation) {
        return this;
    }

    @Override
    protected ClientTransportFactory buildTransportFactory() {
        return new InProcessClientTransportFactory(this.name);
    }

    @Override
    public InProcessChannelBuilder statsContextFactory(StatsContextFactory statsFactory) {
        return this;
    }

    static final class InProcessClientTransportFactory
    implements ClientTransportFactory {
        private final String name;
        private boolean closed;

        private InProcessClientTransportFactory(String name) {
            this.name = name;
        }

        @Override
        public ConnectionClientTransport newClientTransport(SocketAddress addr, String authority, String userAgent) {
            if (this.closed) {
                throw new IllegalStateException("The transport factory is closed.");
            }
            return new InProcessTransport(this.name, authority);
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }
}

