/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal;

import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.beam.repackaged.beam_runners_direct_java.com.google.common.base.MoreObjects;
import org.apache.beam.repackaged.beam_runners_direct_java.com.google.common.base.Preconditions;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.Metadata;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.Status;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal.AbstractStream;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal.ClientStream;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal.ClientStreamListener;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal.ReadableBuffer;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal.ReadableBuffers;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal.StatsTraceContext;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal.WritableBuffer;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal.WritableBufferAllocator;

public abstract class AbstractClientStream
extends AbstractStream
implements ClientStream {
    private static final Logger log = Logger.getLogger(AbstractClientStream.class.getName());
    private ClientStreamListener listener;
    private boolean listenerClosed;
    private Status status;
    private Metadata trailers;
    private Runnable closeListenerTask;
    private volatile boolean cancelled;

    protected AbstractClientStream(WritableBufferAllocator bufferAllocator, int maxMessageSize, StatsTraceContext statsTraceCtx) {
        super(bufferAllocator, maxMessageSize, statsTraceCtx);
    }

    @Override
    public void setMaxInboundMessageSize(int maxSize) {
        this.setMaxInboundMessageSizeProtected(maxSize);
    }

    @Override
    public void setMaxOutboundMessageSize(int maxSize) {
        this.setMaxOutboundMessageSizeProtected(maxSize);
    }

    @Override
    protected final ClientStreamListener listener() {
        return this.listener;
    }

    @Override
    public void start(ClientStreamListener listener) {
        Preconditions.checkState(this.listener == null, "stream already started");
        this.listener = Preconditions.checkNotNull(listener, "listener");
    }

    @Override
    protected void receiveMessage(InputStream is) {
        if (!this.listenerClosed) {
            Preconditions.checkState(this.listener != null, "stream not started");
            this.listener.messageRead(is);
        }
    }

    protected void inboundTransportError(Status errorStatus, Metadata metadata) {
        Preconditions.checkNotNull(metadata, "metadata");
        if (this.inboundPhase() == AbstractStream.Phase.STATUS) {
            log.log(Level.INFO, "Received transport error on closed stream {0} {1}", new Object[]{this.id(), errorStatus});
            return;
        }
        this.transportReportStatus(errorStatus, false, metadata);
    }

    protected void inboundHeadersReceived(Metadata headers) {
        Preconditions.checkState(this.listener != null, "stream not started");
        if (this.inboundPhase() == AbstractStream.Phase.STATUS) {
            log.log(Level.INFO, "Received headers on closed stream {0} {1}", new Object[]{this.id(), headers});
        }
        this.inboundPhase(AbstractStream.Phase.MESSAGE);
        this.listener.headersRead(headers);
    }

    protected void inboundDataReceived(ReadableBuffer frame) {
        Preconditions.checkNotNull(frame, "frame");
        boolean needToCloseFrame = true;
        try {
            if (this.inboundPhase() == AbstractStream.Phase.STATUS) {
                return;
            }
            if (this.inboundPhase() == AbstractStream.Phase.HEADERS) {
                this.inboundTransportError(Status.INTERNAL.withDescription("headers not received before payload"), new Metadata());
                return;
            }
            this.inboundPhase(AbstractStream.Phase.MESSAGE);
            needToCloseFrame = false;
            this.deframe(frame, false);
        }
        finally {
            if (needToCloseFrame) {
                frame.close();
            }
        }
    }

    @Override
    protected void inboundDeliveryPaused() {
        this.runCloseListenerTask();
    }

    @Override
    protected final void deframeFailed(Throwable cause) {
        this.cancel(Status.INTERNAL.withDescription("Exception deframing message").withCause(cause));
    }

    protected void inboundTrailersReceived(Metadata trailers, Status status) {
        Preconditions.checkNotNull(trailers, "trailers");
        if (this.inboundPhase() == AbstractStream.Phase.STATUS) {
            log.log(Level.INFO, "Received trailers on closed stream {0}\n {1}\n {2}", new Object[]{this.id(), status, trailers});
        }
        this.status = status;
        this.trailers = trailers;
        this.deframe(ReadableBuffers.empty(), true);
    }

    @Override
    protected void remoteEndClosed() {
        this.transportReportStatus(this.status, true, this.trailers);
    }

    @Override
    protected final void internalSendFrame(WritableBuffer frame, boolean endOfStream, boolean flush) {
        Preconditions.checkArgument(frame != null || endOfStream, "null frame before EOS");
        this.sendFrame(frame, endOfStream, flush);
    }

    protected abstract void sendFrame(WritableBuffer var1, boolean var2, boolean var3);

    public void transportReportStatus(Status newStatus, boolean stopDelivery, Metadata trailers) {
        boolean closingLater;
        Preconditions.checkNotNull(newStatus, "newStatus");
        boolean bl = closingLater = this.closeListenerTask != null && !stopDelivery;
        if (this.listenerClosed || closingLater) {
            return;
        }
        this.inboundPhase(AbstractStream.Phase.STATUS);
        this.status = newStatus;
        this.closeListenerTask = null;
        boolean deliveryStalled = this.isDeframerStalled();
        if (stopDelivery || deliveryStalled) {
            this.closeListener(newStatus, trailers);
        } else {
            this.closeListenerTask = this.newCloseListenerTask(newStatus, trailers);
        }
    }

    private Runnable newCloseListenerTask(final Status status, final Metadata trailers) {
        return new Runnable(){

            @Override
            public void run() {
                AbstractClientStream.this.closeListener(status, trailers);
            }
        };
    }

    private void closeListener(Status newStatus, Metadata trailers) {
        Preconditions.checkState(this.listener != null, "stream not started");
        if (!this.listenerClosed) {
            this.listenerClosed = true;
            this.closeDeframer();
            this.listener.closed(newStatus, trailers);
        }
    }

    private void runCloseListenerTask() {
        if (this.closeListenerTask != null) {
            this.closeListenerTask.run();
            this.closeListenerTask = null;
        }
    }

    @Override
    public final void halfClose() {
        if (this.outboundPhase(AbstractStream.Phase.STATUS) != AbstractStream.Phase.STATUS) {
            this.closeFramer();
        }
    }

    @Override
    public final void cancel(Status reason) {
        Preconditions.checkArgument(!reason.isOk(), "Should not cancel with OK status");
        this.cancelled = true;
        this.sendCancel(reason);
        this.dispose();
    }

    @Override
    public final boolean isReady() {
        return !this.cancelled && super.isReady();
    }

    protected abstract void sendCancel(Status var1);

    @Override
    protected MoreObjects.ToStringHelper toStringHelper() {
        MoreObjects.ToStringHelper toStringHelper = super.toStringHelper();
        if (this.status != null) {
            toStringHelper.add("status", this.status);
        }
        return toStringHelper;
    }

    @Override
    public boolean isClosed() {
        return super.isClosed() || this.listenerClosed;
    }
}

