/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal;

import com.google.instrumentation.stats.Stats;
import com.google.instrumentation.stats.StatsContextFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import org.apache.beam.repackaged.beam_runners_direct_java.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.repackaged.beam_runners_direct_java.com.google.common.base.MoreObjects;
import org.apache.beam.repackaged.beam_runners_direct_java.com.google.common.base.Preconditions;
import org.apache.beam.repackaged.beam_runners_direct_java.com.google.common.util.concurrent.MoreExecutors;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.BindableService;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.CompressorRegistry;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.Context;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.DecompressorRegistry;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.HandlerRegistry;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.InternalNotifyOnServerBuild;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.ServerBuilder;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.ServerMethodDefinition;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.ServerServiceDefinition;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.ServerTransportFilter;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal.GrpcUtil;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal.InternalHandlerRegistry;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal.InternalServer;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal.NoopStatsContextFactory;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal.ObjectPool;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal.ServerImpl;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal.SharedResourcePool;

public abstract class AbstractServerImplBuilder<T extends AbstractServerImplBuilder<T>>
extends ServerBuilder<T> {
    private static final HandlerRegistry EMPTY_FALLBACK_REGISTRY = new HandlerRegistry(){

        @Override
        public List<ServerServiceDefinition> getServices() {
            return Collections.emptyList();
        }

        @Override
        public ServerMethodDefinition<?, ?> lookupMethod(String methodName, @Nullable String authority) {
            return null;
        }
    };
    private final InternalHandlerRegistry.Builder registryBuilder = new InternalHandlerRegistry.Builder();
    private final ArrayList<ServerTransportFilter> transportFilters = new ArrayList();
    private final List<InternalNotifyOnServerBuild> notifyOnBuildList = new ArrayList<InternalNotifyOnServerBuild>();
    @Nullable
    private HandlerRegistry fallbackRegistry;
    @Nullable
    private Executor executor;
    @Nullable
    private DecompressorRegistry decompressorRegistry;
    @Nullable
    private CompressorRegistry compressorRegistry;
    @Nullable
    private StatsContextFactory statsFactory;

    @Override
    public final T directExecutor() {
        return (T)this.executor(MoreExecutors.directExecutor());
    }

    @Override
    public final T executor(@Nullable Executor executor) {
        this.executor = executor;
        return this.thisT();
    }

    @Override
    public final T addService(ServerServiceDefinition service) {
        this.registryBuilder.addService(service);
        return this.thisT();
    }

    @Override
    public final T addService(BindableService bindableService) {
        if (bindableService instanceof InternalNotifyOnServerBuild) {
            this.notifyOnBuildList.add((InternalNotifyOnServerBuild)((Object)bindableService));
        }
        return (T)this.addService(bindableService.bindService());
    }

    @Override
    public final T addTransportFilter(ServerTransportFilter filter) {
        this.transportFilters.add(Preconditions.checkNotNull(filter, "filter"));
        return this.thisT();
    }

    @Override
    public final T fallbackHandlerRegistry(HandlerRegistry registry) {
        this.fallbackRegistry = registry;
        return this.thisT();
    }

    @Override
    public final T decompressorRegistry(DecompressorRegistry registry) {
        this.decompressorRegistry = registry;
        return this.thisT();
    }

    @Override
    public final T compressorRegistry(CompressorRegistry registry) {
        this.compressorRegistry = registry;
        return this.thisT();
    }

    @VisibleForTesting
    protected T statsContextFactory(StatsContextFactory statsFactory) {
        this.statsFactory = statsFactory;
        return this.thisT();
    }

    @Override
    public ServerImpl build() {
        InternalServer transportServer = this.buildTransportServer();
        ServerImpl server = new ServerImpl(this.getExecutorPool(), SharedResourcePool.forResource(GrpcUtil.TIMER_SERVICE), this.registryBuilder.build(), MoreObjects.firstNonNull(this.fallbackRegistry, EMPTY_FALLBACK_REGISTRY), transportServer, Context.ROOT, MoreObjects.firstNonNull(this.decompressorRegistry, DecompressorRegistry.getDefaultInstance()), MoreObjects.firstNonNull(this.compressorRegistry, CompressorRegistry.getDefaultInstance()), this.transportFilters, MoreObjects.firstNonNull(this.statsFactory, MoreObjects.firstNonNull(Stats.getStatsContextFactory(), NoopStatsContextFactory.INSTANCE)), GrpcUtil.STOPWATCH_SUPPLIER);
        for (InternalNotifyOnServerBuild notifyTarget : this.notifyOnBuildList) {
            notifyTarget.notifyOnBuild(server);
        }
        return server;
    }

    private ObjectPool<? extends Executor> getExecutorPool() {
        final Executor savedExecutor = this.executor;
        if (savedExecutor == null) {
            return SharedResourcePool.forResource(GrpcUtil.SHARED_CHANNEL_EXECUTOR);
        }
        return new ObjectPool<Executor>(){

            @Override
            public Executor getObject() {
                return savedExecutor;
            }

            @Override
            public Executor returnObject(Object object) {
                return null;
            }
        };
    }

    protected abstract InternalServer buildTransportServer();

    private T thisT() {
        AbstractServerImplBuilder thisT = this;
        return (T)thisT;
    }
}

