/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal;

import javax.annotation.Nullable;
import org.apache.beam.repackaged.beam_runners_direct_java.com.google.common.base.Preconditions;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.Attributes;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.Metadata;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.Status;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal.AbstractStream2;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal.MessageFramer;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal.ReadableBuffer;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal.ServerStream;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal.ServerStreamListener;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal.StatsTraceContext;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal.WritableBuffer;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal.WritableBufferAllocator;

public abstract class AbstractServerStream
extends AbstractStream2
implements ServerStream,
MessageFramer.Sink {
    private final MessageFramer framer;
    private final StatsTraceContext statsTraceCtx;
    private boolean outboundClosed;
    private boolean headersSent;

    protected AbstractServerStream(WritableBufferAllocator bufferAllocator, StatsTraceContext statsTraceCtx) {
        this.statsTraceCtx = Preconditions.checkNotNull(statsTraceCtx, "statsTraceCtx");
        this.framer = new MessageFramer(this, bufferAllocator, statsTraceCtx);
    }

    @Override
    protected abstract TransportState transportState();

    protected abstract Sink abstractServerStreamSink();

    @Override
    protected final MessageFramer framer() {
        return this.framer;
    }

    @Override
    public final void request(int numMessages) {
        this.abstractServerStreamSink().request(numMessages);
    }

    @Override
    public final void writeHeaders(Metadata headers) {
        Preconditions.checkNotNull(headers, "headers");
        this.headersSent = true;
        this.abstractServerStreamSink().writeHeaders(headers);
    }

    @Override
    public final void deliverFrame(WritableBuffer frame, boolean endOfStream, boolean flush) {
        this.abstractServerStreamSink().writeFrame(frame, endOfStream ? false : flush);
    }

    @Override
    public final void close(Status status, Metadata trailers) {
        Preconditions.checkNotNull(status, "status");
        Preconditions.checkNotNull(trailers, "trailers");
        if (!this.outboundClosed) {
            this.outboundClosed = true;
            this.endOfMessages();
            this.addStatusToTrailers(trailers, status);
            this.abstractServerStreamSink().writeTrailers(trailers, this.headersSent);
        }
    }

    private void addStatusToTrailers(Metadata trailers, Status status) {
        trailers.discardAll(Status.CODE_KEY);
        trailers.discardAll(Status.MESSAGE_KEY);
        trailers.put(Status.CODE_KEY, status);
        if (status.getDescription() != null) {
            trailers.put(Status.MESSAGE_KEY, status.getDescription());
        }
    }

    @Override
    public final void cancel(Status status) {
        this.abstractServerStreamSink().cancel(status);
    }

    @Override
    public final boolean isReady() {
        return super.isReady();
    }

    @Override
    public Attributes getAttributes() {
        return Attributes.EMPTY;
    }

    @Override
    public String getAuthority() {
        return null;
    }

    @Override
    public final void setListener(ServerStreamListener serverStreamListener) {
        this.transportState().setListener(serverStreamListener);
    }

    @Override
    public StatsTraceContext statsTraceContext() {
        return this.statsTraceCtx;
    }

    protected static abstract class TransportState
    extends AbstractStream2.TransportState {
        private boolean listenerClosed;
        private ServerStreamListener listener;

        protected TransportState(int maxMessageSize, StatsTraceContext statsTraceCtx) {
            super(maxMessageSize, statsTraceCtx);
        }

        public final void setListener(ServerStreamListener listener) {
            Preconditions.checkState(this.listener == null, "setListener should be called only once");
            this.listener = Preconditions.checkNotNull(listener, "listener");
        }

        @Override
        public final void onStreamAllocated() {
            super.onStreamAllocated();
        }

        @Override
        public void deliveryStalled() {
        }

        @Override
        public void endOfStream() {
            this.closeDeframer();
            this.listener().halfClosed();
        }

        @Override
        protected ServerStreamListener listener() {
            return this.listener;
        }

        public void inboundDataReceived(ReadableBuffer frame, boolean endOfStream) {
            this.deframe(frame, endOfStream);
        }

        public final void transportReportStatus(Status status) {
            Preconditions.checkArgument(!status.isOk(), "status must not be OK");
            this.closeListener(status);
        }

        public void complete() {
            this.closeListener(Status.OK);
        }

        private void closeListener(Status newStatus) {
            if (!this.listenerClosed) {
                this.listenerClosed = true;
                this.onStreamDeallocated();
                this.closeDeframer();
                this.listener().closed(newStatus);
            }
        }
    }

    protected static interface Sink {
        public void writeHeaders(Metadata var1);

        public void writeFrame(@Nullable WritableBuffer var1, boolean var2);

        public void writeTrailers(Metadata var1, boolean var2);

        public void request(int var1);

        public void cancel(Status var1);
    }
}

