/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal;

import java.net.SocketAddress;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import org.apache.beam.repackaged.beam_runners_direct_java.com.google.common.base.MoreObjects;
import org.apache.beam.repackaged.beam_runners_direct_java.com.google.common.base.Preconditions;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.Attributes;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.CallCredentials;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.CallOptions;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.Metadata;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.MethodDescriptor;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.SecurityLevel;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal.ClientStream;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal.ClientTransportFactory;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal.ConnectionClientTransport;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal.ForwardingConnectionClientTransport;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal.MetadataApplierImpl;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal.StatsTraceContext;

final class CallCredentialsApplyingTransportFactory
implements ClientTransportFactory {
    private final ClientTransportFactory delegate;
    private final Executor appExecutor;

    CallCredentialsApplyingTransportFactory(ClientTransportFactory delegate, Executor appExecutor) {
        this.delegate = Preconditions.checkNotNull(delegate, "delegate");
        this.appExecutor = Preconditions.checkNotNull(appExecutor, "appExecutor");
    }

    @Override
    public ConnectionClientTransport newClientTransport(SocketAddress serverAddress, String authority, @Nullable String userAgent) {
        return new CallCredentialsApplyingTransport(this.delegate.newClientTransport(serverAddress, authority, userAgent), authority);
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    private class CallCredentialsApplyingTransport
    extends ForwardingConnectionClientTransport {
        private final ConnectionClientTransport delegate;
        private final String authority;

        CallCredentialsApplyingTransport(ConnectionClientTransport delegate, String authority) {
            this.delegate = Preconditions.checkNotNull(delegate, "delegate");
            this.authority = Preconditions.checkNotNull(authority, "authority");
        }

        @Override
        protected ConnectionClientTransport delegate() {
            return this.delegate;
        }

        @Override
        public ClientStream newStream(MethodDescriptor<?, ?> method, Metadata headers, CallOptions callOptions, StatsTraceContext statsTraceCtx) {
            CallCredentials creds = callOptions.getCredentials();
            if (creds != null) {
                MetadataApplierImpl applier = new MetadataApplierImpl(this.delegate, method, headers, callOptions, statsTraceCtx);
                Attributes.Builder effectiveAttrsBuilder = Attributes.newBuilder().set(CallCredentials.ATTR_AUTHORITY, this.authority).set(CallCredentials.ATTR_SECURITY_LEVEL, SecurityLevel.NONE).setAll(this.delegate.getAttributes());
                if (callOptions.getAuthority() != null) {
                    effectiveAttrsBuilder.set(CallCredentials.ATTR_AUTHORITY, callOptions.getAuthority());
                }
                creds.applyRequestMetadata(method, effectiveAttrsBuilder.build(), MoreObjects.firstNonNull(callOptions.getExecutor(), CallCredentialsApplyingTransportFactory.this.appExecutor), applier);
                return applier.returnStream();
            }
            return this.delegate.newStream(method, headers, callOptions, statsTraceCtx);
        }
    }
}

