/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.beam.repackaged.beam_runners_direct_java.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.CallOptions;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.Context;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.LoadBalancer;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.Metadata;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.MethodDescriptor;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.Status;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal.ChannelExecutor;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal.ClientStream;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal.ClientTransport;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal.DelayedStream;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal.FailingClientStream;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal.GrpcUtil;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal.LogId;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal.ManagedClientTransport;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal.PickSubchannelArgsImpl;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal.StatsTraceContext;

final class DelayedClientTransport
implements ManagedClientTransport {
    private final LogId lodId = LogId.allocate(this.getClass().getName());
    private final Object lock = new Object();
    private final Executor defaultAppExecutor;
    private final ChannelExecutor channelExecutor;
    private Runnable reportTransportInUse;
    private Runnable reportTransportNotInUse;
    private Runnable reportTransportShutdown;
    private Runnable reportTransportTerminated;
    @GuardedBy(value="lock")
    private Collection<PendingStream> pendingStreams = new LinkedHashSet<PendingStream>();
    @GuardedBy(value="lock")
    private boolean shutdown;
    @Nullable
    @GuardedBy(value="lock")
    private LoadBalancer.SubchannelPicker lastPicker;
    @GuardedBy(value="lock")
    private long lastPickerVersion;

    DelayedClientTransport(Executor defaultAppExecutor, ChannelExecutor channelExecutor) {
        this.defaultAppExecutor = defaultAppExecutor;
        this.channelExecutor = channelExecutor;
    }

    @Override
    public final Runnable start(final ManagedClientTransport.Listener listener) {
        this.reportTransportInUse = new Runnable(){

            @Override
            public void run() {
                listener.transportInUse(true);
            }
        };
        this.reportTransportNotInUse = new Runnable(){

            @Override
            public void run() {
                listener.transportInUse(false);
            }
        };
        this.reportTransportShutdown = new Runnable(){

            @Override
            public void run() {
                listener.transportShutdown(Status.UNAVAILABLE.withDescription("Channel requested transport to shut down"));
            }
        };
        this.reportTransportTerminated = new Runnable(){

            @Override
            public void run() {
                listener.transportTerminated();
            }
        };
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public final ClientStream newStream(MethodDescriptor<?, ?> method, Metadata headers, CallOptions callOptions, StatsTraceContext statsTraceCtx) {
        try {
            LoadBalancer.SubchannelPicker picker = null;
            PickSubchannelArgsImpl args = new PickSubchannelArgsImpl(method, headers, callOptions);
            long pickerVersion = -1L;
            Object object = this.lock;
            // MONITORENTER : object
            if (!this.shutdown) {
                if (this.lastPicker == null) {
                    PendingStream pendingStream = this.createPendingStream(args, statsTraceCtx);
                    // MONITOREXIT : object
                    return pendingStream;
                }
                picker = this.lastPicker;
                pickerVersion = this.lastPickerVersion;
            }
            // MONITOREXIT : object
            if (picker != null) {
                while (true) {
                    Object object2;
                    LoadBalancer.PickResult pickResult;
                    ClientTransport transport;
                    if ((transport = GrpcUtil.getTransportFromPickResult(pickResult = picker.pickSubchannel(args), callOptions.isWaitForReady())) != null) {
                        object2 = transport.newStream(((LoadBalancer.PickSubchannelArgs)args).getMethodDescriptor(), ((LoadBalancer.PickSubchannelArgs)args).getHeaders(), ((LoadBalancer.PickSubchannelArgs)args).getCallOptions(), statsTraceCtx);
                        return object2;
                    }
                    object2 = this.lock;
                    // MONITORENTER : object2
                    if (this.shutdown) {
                        // MONITOREXIT : object2
                        break;
                    }
                    if (pickerVersion == this.lastPickerVersion) {
                        PendingStream pendingStream = this.createPendingStream(args, statsTraceCtx);
                        // MONITOREXIT : object2
                        return pendingStream;
                    }
                    picker = this.lastPicker;
                    pickerVersion = this.lastPickerVersion;
                    // MONITOREXIT : object2
                }
            }
            object = new FailingClientStream(Status.UNAVAILABLE.withDescription("Channel has shutdown (reported by delayed transport)"));
            return object;
        }
        finally {
            this.channelExecutor.drain();
        }
    }

    @Override
    public final ClientStream newStream(MethodDescriptor<?, ?> method, Metadata headers) {
        return this.newStream(method, headers, CallOptions.DEFAULT, StatsTraceContext.NOOP);
    }

    @GuardedBy(value="lock")
    private PendingStream createPendingStream(LoadBalancer.PickSubchannelArgs args, StatsTraceContext statsTraceCtx) {
        PendingStream pendingStream = new PendingStream(args, statsTraceCtx);
        this.pendingStreams.add(pendingStream);
        if (this.pendingStreams.size() == 1) {
            this.channelExecutor.executeLater(this.reportTransportInUse);
        }
        return pendingStream;
    }

    @Override
    public final void ping(ClientTransport.PingCallback callback, Executor executor) {
        throw new UnsupportedOperationException("This method is not expected to be called");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void shutdown() {
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown) {
                return;
            }
            this.shutdown = true;
            this.channelExecutor.executeLater(this.reportTransportShutdown);
            if (this.pendingStreams == null || this.pendingStreams.isEmpty()) {
                this.pendingStreams = null;
                this.channelExecutor.executeLater(this.reportTransportTerminated);
            }
        }
        this.channelExecutor.drain();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void shutdownNow(Status status) {
        this.shutdown();
        Collection<PendingStream> savedPendingStreams = null;
        Iterator<PendingStream> iterator = this.lock;
        synchronized (iterator) {
            if (this.pendingStreams != null) {
                savedPendingStreams = this.pendingStreams;
                this.pendingStreams = null;
            }
        }
        if (savedPendingStreams != null) {
            for (PendingStream stream : savedPendingStreams) {
                stream.cancel(status);
            }
            this.channelExecutor.executeLater(this.reportTransportTerminated).drain();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hasPendingStreams() {
        Object object = this.lock;
        synchronized (object) {
            return this.pendingStreams != null && !this.pendingStreams.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    final int getPendingStreamsCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.pendingStreams == null ? 0 : this.pendingStreams.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void reprocess(LoadBalancer.SubchannelPicker picker) {
        ArrayList<PendingStream> toProcess;
        ArrayList<PendingStream> toRemove = new ArrayList<PendingStream>();
        Object object = this.lock;
        synchronized (object) {
            this.lastPicker = picker;
            ++this.lastPickerVersion;
            if (this.pendingStreams == null || this.pendingStreams.isEmpty()) {
                return;
            }
            toProcess = new ArrayList<PendingStream>(this.pendingStreams);
        }
        for (final PendingStream stream : toProcess) {
            CallOptions callOptions;
            LoadBalancer.PickResult pickResult = picker.pickSubchannel(stream.args);
            final ClientTransport transport = GrpcUtil.getTransportFromPickResult(pickResult, (callOptions = stream.args.getCallOptions()).isWaitForReady());
            if (transport == null) continue;
            Executor executor = this.defaultAppExecutor;
            if (callOptions.getExecutor() != null) {
                executor = callOptions.getExecutor();
            }
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    stream.createRealStream(transport);
                }
            });
            toRemove.add(stream);
        }
        object = this.lock;
        synchronized (object) {
            if (this.pendingStreams == null || this.pendingStreams.isEmpty()) {
                return;
            }
            this.pendingStreams.removeAll(toRemove);
            if (this.pendingStreams.isEmpty()) {
                this.channelExecutor.executeLater(this.reportTransportNotInUse);
                if (this.shutdown) {
                    this.pendingStreams = null;
                    this.channelExecutor.executeLater(this.reportTransportTerminated);
                } else {
                    this.pendingStreams = new LinkedHashSet<PendingStream>();
                }
            }
        }
        this.channelExecutor.drain();
    }

    @Override
    public LogId getLogId() {
        return this.lodId;
    }

    private class PendingStream
    extends DelayedStream {
        private final LoadBalancer.PickSubchannelArgs args;
        private final StatsTraceContext statsTraceCtx;
        private final Context context = Context.current();

        private PendingStream(LoadBalancer.PickSubchannelArgs args, StatsTraceContext statsTraceCtx) {
            this.args = args;
            this.statsTraceCtx = statsTraceCtx;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void createRealStream(ClientTransport transport) {
            ClientStream realStream;
            Context origContext = this.context.attach();
            try {
                realStream = transport.newStream(this.args.getMethodDescriptor(), this.args.getHeaders(), this.args.getCallOptions(), this.statsTraceCtx);
            }
            finally {
                this.context.detach(origContext);
            }
            this.setStream(realStream);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancel(Status reason) {
            super.cancel(reason);
            Object object = DelayedClientTransport.this.lock;
            synchronized (object) {
                if (DelayedClientTransport.this.pendingStreams != null) {
                    boolean justRemovedAnElement = DelayedClientTransport.this.pendingStreams.remove(this);
                    if (DelayedClientTransport.this.pendingStreams.isEmpty() && justRemovedAnElement) {
                        DelayedClientTransport.this.channelExecutor.executeLater(DelayedClientTransport.this.reportTransportNotInUse);
                        if (DelayedClientTransport.this.shutdown) {
                            DelayedClientTransport.this.pendingStreams = null;
                            DelayedClientTransport.this.channelExecutor.executeLater(DelayedClientTransport.this.reportTransportTerminated);
                        }
                    }
                }
            }
            DelayedClientTransport.this.channelExecutor.drain();
        }
    }
}

