/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal;

import java.util.concurrent.Executor;
import org.apache.beam.repackaged.beam_runners_direct_java.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.repackaged.beam_runners_direct_java.com.google.common.base.Preconditions;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.CallOptions;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.Metadata;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.MethodDescriptor;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.Status;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal.ClientStream;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal.ClientTransport;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal.FailingClientStream;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal.StatsTraceContext;

class FailingClientTransport
implements ClientTransport {
    @VisibleForTesting
    final Status error;

    FailingClientTransport(Status error) {
        Preconditions.checkArgument(!error.isOk(), "error must not be OK");
        this.error = error;
    }

    @Override
    public ClientStream newStream(MethodDescriptor<?, ?> method, Metadata headers, CallOptions callOptions, StatsTraceContext statsTraceCtx) {
        return new FailingClientStream(this.error);
    }

    @Override
    public ClientStream newStream(MethodDescriptor<?, ?> method, Metadata headers) {
        return this.newStream(method, headers, CallOptions.DEFAULT, StatsTraceContext.NOOP);
    }

    @Override
    public void ping(final ClientTransport.PingCallback callback, Executor executor) {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                callback.onFailure(FailingClientTransport.this.error.asException());
            }
        });
    }
}

