/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.beam.repackaged.beam_runners_direct_java.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.repackaged.beam_runners_direct_java.com.google.common.base.Preconditions;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.Attributes;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.Codec;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.Compressor;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.CompressorRegistry;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.Context;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.Decompressor;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.DecompressorRegistry;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.InternalDecompressorRegistry;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.Metadata;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.MethodDescriptor;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.ServerCall;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.Status;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal.GrpcUtil;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal.MoreThrowables;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal.ServerStream;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal.ServerStreamListener;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal.StatsTraceContext;

final class ServerCallImpl<ReqT, RespT>
extends ServerCall<ReqT, RespT> {
    private final ServerStream stream;
    private final MethodDescriptor<ReqT, RespT> method;
    private final Context.CancellableContext context;
    private final byte[] messageAcceptEncoding;
    private final DecompressorRegistry decompressorRegistry;
    private final CompressorRegistry compressorRegistry;
    private final StatsTraceContext statsTraceCtx;
    private volatile boolean cancelled;
    private boolean sendHeadersCalled;
    private boolean closeCalled;
    private Compressor compressor;

    ServerCallImpl(ServerStream stream, MethodDescriptor<ReqT, RespT> method, Metadata inboundHeaders, Context.CancellableContext context, StatsTraceContext statsTraceCtx, DecompressorRegistry decompressorRegistry, CompressorRegistry compressorRegistry) {
        this.stream = stream;
        this.method = method;
        this.context = context;
        this.messageAcceptEncoding = inboundHeaders.get(GrpcUtil.MESSAGE_ACCEPT_ENCODING_KEY);
        this.decompressorRegistry = decompressorRegistry;
        this.compressorRegistry = compressorRegistry;
        this.statsTraceCtx = Preconditions.checkNotNull(statsTraceCtx, "statsTraceCtx");
        if (inboundHeaders.containsKey(GrpcUtil.MESSAGE_ENCODING_KEY)) {
            String encoding = inboundHeaders.get(GrpcUtil.MESSAGE_ENCODING_KEY);
            Decompressor decompressor = decompressorRegistry.lookupDecompressor(encoding);
            if (decompressor == null) {
                throw Status.UNIMPLEMENTED.withDescription(String.format("Can't find decompressor for %s", encoding)).asRuntimeException();
            }
            stream.setDecompressor(decompressor);
        }
    }

    @Override
    public void request(int numMessages) {
        this.stream.request(numMessages);
    }

    @Override
    public void sendHeaders(Metadata headers) {
        Preconditions.checkState(!this.sendHeadersCalled, "sendHeaders has already been called");
        Preconditions.checkState(!this.closeCalled, "call is closed");
        headers.discardAll(GrpcUtil.MESSAGE_ENCODING_KEY);
        if (this.compressor == null) {
            this.compressor = Codec.Identity.NONE;
        } else if (this.messageAcceptEncoding != null) {
            List<String> acceptedEncodingsList = GrpcUtil.ACCEPT_ENCODING_SPLITTER.splitToList(new String(this.messageAcceptEncoding, GrpcUtil.US_ASCII));
            if (!acceptedEncodingsList.contains(this.compressor.getMessageEncoding())) {
                this.compressor = Codec.Identity.NONE;
            }
        } else {
            this.compressor = Codec.Identity.NONE;
        }
        headers.put(GrpcUtil.MESSAGE_ENCODING_KEY, this.compressor.getMessageEncoding());
        this.stream.setCompressor(this.compressor);
        headers.discardAll(GrpcUtil.MESSAGE_ACCEPT_ENCODING_KEY);
        byte[] advertisedEncodings = InternalDecompressorRegistry.getRawAdvertisedMessageEncodings(this.decompressorRegistry);
        if (advertisedEncodings.length != 0) {
            headers.put(GrpcUtil.MESSAGE_ACCEPT_ENCODING_KEY, advertisedEncodings);
        }
        this.sendHeadersCalled = true;
        this.stream.writeHeaders(headers);
    }

    @Override
    public void sendMessage(RespT message) {
        Preconditions.checkState(this.sendHeadersCalled, "sendHeaders has not been called");
        Preconditions.checkState(!this.closeCalled, "call is closed");
        try {
            InputStream resp = this.method.streamResponse(message);
            this.stream.writeMessage(resp);
            this.stream.flush();
        }
        catch (RuntimeException e) {
            this.close(Status.fromThrowable(e), new Metadata());
            throw e;
        }
        catch (Throwable t) {
            this.close(Status.fromThrowable(t), new Metadata());
            throw new RuntimeException(t);
        }
    }

    @Override
    public void setMessageCompression(boolean enable) {
        this.stream.setMessageCompression(enable);
    }

    @Override
    public void setCompression(String compressorName) {
        Preconditions.checkState(!this.sendHeadersCalled, "sendHeaders has been called");
        this.compressor = this.compressorRegistry.lookupCompressor(compressorName);
        Preconditions.checkArgument(this.compressor != null, "Unable to find compressor by name %s", new Object[]{compressorName});
    }

    @Override
    public boolean isReady() {
        return this.stream.isReady();
    }

    @Override
    public void close(Status status, Metadata trailers) {
        Preconditions.checkState(!this.closeCalled, "call already closed");
        this.closeCalled = true;
        this.stream.close(status, trailers);
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    ServerStreamListener newServerStreamListener(ServerCall.Listener<ReqT> listener) {
        return new ServerStreamListenerImpl<ReqT>(this, listener, this.context, this.statsTraceCtx);
    }

    @Override
    public Attributes getAttributes() {
        return this.stream.getAttributes();
    }

    @Override
    public MethodDescriptor<ReqT, RespT> getMethodDescriptor() {
        return this.method;
    }

    @VisibleForTesting
    static final class ServerStreamListenerImpl<ReqT>
    implements ServerStreamListener {
        private final ServerCallImpl<ReqT, ?> call;
        private final ServerCall.Listener<ReqT> listener;
        private final Context.CancellableContext context;
        private final StatsTraceContext statsTraceCtx;
        private boolean messageReceived;

        public ServerStreamListenerImpl(ServerCallImpl<ReqT, ?> call, ServerCall.Listener<ReqT> listener, Context.CancellableContext context, StatsTraceContext statsTraceCtx) {
            this.call = Preconditions.checkNotNull(call, "call");
            this.listener = Preconditions.checkNotNull(listener, "listener must not be null");
            this.context = Preconditions.checkNotNull(context, "context");
            this.statsTraceCtx = Preconditions.checkNotNull(statsTraceCtx, "statsTraceCtx");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void messageRead(InputStream message) {
            Throwable t = null;
            try {
                if (((ServerCallImpl)this.call).cancelled) {
                    return;
                }
                if (this.messageReceived && ((ServerCallImpl)this.call).method.getType() == MethodDescriptor.MethodType.UNARY) {
                    ((ServerCallImpl)this.call).stream.close(Status.INTERNAL.withDescription("More than one request messages for unary call or server streaming call"), new Metadata());
                    return;
                }
                this.messageReceived = true;
                this.listener.onMessage(((ServerCallImpl)this.call).method.parseRequest(message));
                return;
            }
            catch (Throwable e) {
                t = e;
            }
            finally {
                try {
                    message.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    if (t != null) {
                        MoreThrowables.throwIfUnchecked(t);
                        throw new RuntimeException(t);
                    }
                }
            }
        }

        @Override
        public void halfClosed() {
            if (((ServerCallImpl)this.call).cancelled) {
                return;
            }
            this.listener.onHalfClose();
        }

        @Override
        public void closed(Status status) {
            try {
                this.statsTraceCtx.callEnded(status);
                if (status.isOk()) {
                    this.listener.onComplete();
                } else {
                    ((ServerCallImpl)this.call).cancelled = true;
                    this.listener.onCancel();
                }
            }
            finally {
                this.context.cancel(null);
            }
        }

        @Override
        public void onReady() {
            if (((ServerCallImpl)this.call).cancelled) {
                return;
            }
            this.listener.onReady();
        }
    }
}

