/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal;

import com.google.instrumentation.stats.MeasurementDescriptor;
import com.google.instrumentation.stats.MeasurementMap;
import com.google.instrumentation.stats.RpcConstants;
import com.google.instrumentation.stats.StatsContext;
import com.google.instrumentation.stats.StatsContextFactory;
import com.google.instrumentation.stats.TagKey;
import com.google.instrumentation.stats.TagValue;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.beam.repackaged.beam_runners_direct_java.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.repackaged.beam_runners_direct_java.com.google.common.base.Preconditions;
import org.apache.beam.repackaged.beam_runners_direct_java.com.google.common.base.Stopwatch;
import org.apache.beam.repackaged.beam_runners_direct_java.com.google.common.base.Supplier;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.Metadata;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.Status;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal.GrpcUtil;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal.NoopStatsContextFactory;

public final class StatsTraceContext {
    public static final StatsTraceContext NOOP = StatsTraceContext.newClientContext("noopservice/noopmethod", NoopStatsContextFactory.INSTANCE, GrpcUtil.STOPWATCH_SUPPLIER);
    private static final double NANOS_PER_MILLI = 1000000.0;
    private final StatsContext statsCtx;
    private final Stopwatch stopwatch;
    private final Side side;
    private final Metadata.Key<StatsContext> statsHeader;
    private volatile long clientPendingNanos = -1L;
    private volatile long wireBytesSent;
    private volatile long wireBytesReceived;
    private volatile long uncompressedBytesSent;
    private volatile long uncompressedBytesReceived;
    private final AtomicBoolean callEnded = new AtomicBoolean(false);

    private StatsTraceContext(Side side, String fullMethodName, StatsContext parentCtx, Supplier<Stopwatch> stopwatchSupplier, Metadata.Key<StatsContext> statsHeader) {
        this.side = side;
        TagKey methodTagKey = side == Side.CLIENT ? RpcConstants.RPC_CLIENT_METHOD : RpcConstants.RPC_SERVER_METHOD;
        this.statsCtx = parentCtx.with(methodTagKey, TagValue.create((String)fullMethodName));
        this.stopwatch = stopwatchSupplier.get().start();
        this.statsHeader = statsHeader;
    }

    public static StatsTraceContext newClientContext(String methodName, StatsContextFactory statsFactory, Supplier<Stopwatch> stopwatchSupplier) {
        return new StatsTraceContext(Side.CLIENT, methodName, statsFactory.getDefault(), stopwatchSupplier, StatsTraceContext.createStatsHeader(statsFactory));
    }

    @VisibleForTesting
    static StatsTraceContext newClientContextForTesting(String methodName, StatsContextFactory statsFactory, StatsContext parent, Supplier<Stopwatch> stopwatchSupplier) {
        return new StatsTraceContext(Side.CLIENT, methodName, parent, stopwatchSupplier, StatsTraceContext.createStatsHeader(statsFactory));
    }

    public static StatsTraceContext newServerContext(String methodName, StatsContextFactory statsFactory, Metadata headers, Supplier<Stopwatch> stopwatchSupplier) {
        Metadata.Key<StatsContext> statsHeader = StatsTraceContext.createStatsHeader(statsFactory);
        StatsContext parentCtx = headers.get(statsHeader);
        if (parentCtx == null) {
            parentCtx = statsFactory.getDefault();
        }
        return new StatsTraceContext(Side.SERVER, methodName, parentCtx, stopwatchSupplier, statsHeader);
    }

    void propagateToHeaders(Metadata headers) {
        headers.discardAll(this.statsHeader);
        headers.put(this.statsHeader, this.statsCtx);
    }

    Metadata.Key<StatsContext> getStatsHeader() {
        return this.statsHeader;
    }

    @VisibleForTesting
    StatsContext getStatsContext() {
        return this.statsCtx;
    }

    @VisibleForTesting
    static Metadata.Key<StatsContext> createStatsHeader(final StatsContextFactory statsCtxFactory) {
        return Metadata.Key.of("grpc-census-bin", new Metadata.BinaryMarshaller<StatsContext>(){

            @Override
            public byte[] toBytes(StatsContext context) {
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                try {
                    context.serialize((OutputStream)buffer);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return buffer.toByteArray();
            }

            @Override
            public StatsContext parseBytes(byte[] serialized) {
                try {
                    return statsCtxFactory.deserialize((InputStream)new ByteArrayInputStream(serialized));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    void wireBytesSent(long bytes) {
        this.wireBytesSent += bytes;
    }

    void wireBytesReceived(long bytes) {
        this.wireBytesReceived += bytes;
    }

    void uncompressedBytesSent(long bytes) {
        this.uncompressedBytesSent += bytes;
    }

    void uncompressedBytesReceived(long bytes) {
        this.uncompressedBytesReceived += bytes;
    }

    public void clientHeadersSent() {
        Preconditions.checkState(this.side == Side.CLIENT, "Must be called on client-side");
        if (this.clientPendingNanos < 0L) {
            this.clientPendingNanos = this.stopwatch.elapsed(TimeUnit.NANOSECONDS);
        }
    }

    void callEnded(Status status) {
        MeasurementDescriptor errorCountMetric;
        MeasurementDescriptor uncompressedBytesReceivedMetric;
        MeasurementDescriptor uncompressedBytesSentMetric;
        MeasurementDescriptor wireBytesReceivedMetric;
        MeasurementDescriptor wireBytesSentMetric;
        MeasurementDescriptor latencyMetric;
        if (!this.callEnded.compareAndSet(false, true)) {
            return;
        }
        this.stopwatch.stop();
        if (this.side == Side.CLIENT) {
            latencyMetric = RpcConstants.RPC_CLIENT_ROUNDTRIP_LATENCY;
            wireBytesSentMetric = RpcConstants.RPC_CLIENT_REQUEST_BYTES;
            wireBytesReceivedMetric = RpcConstants.RPC_CLIENT_RESPONSE_BYTES;
            uncompressedBytesSentMetric = RpcConstants.RPC_CLIENT_UNCOMPRESSED_REQUEST_BYTES;
            uncompressedBytesReceivedMetric = RpcConstants.RPC_CLIENT_UNCOMPRESSED_RESPONSE_BYTES;
            errorCountMetric = RpcConstants.RPC_CLIENT_ERROR_COUNT;
        } else {
            latencyMetric = RpcConstants.RPC_SERVER_SERVER_LATENCY;
            wireBytesSentMetric = RpcConstants.RPC_SERVER_RESPONSE_BYTES;
            wireBytesReceivedMetric = RpcConstants.RPC_SERVER_REQUEST_BYTES;
            uncompressedBytesSentMetric = RpcConstants.RPC_SERVER_UNCOMPRESSED_RESPONSE_BYTES;
            uncompressedBytesReceivedMetric = RpcConstants.RPC_SERVER_UNCOMPRESSED_REQUEST_BYTES;
            errorCountMetric = RpcConstants.RPC_SERVER_ERROR_COUNT;
        }
        long roundtripNanos = this.stopwatch.elapsed(TimeUnit.NANOSECONDS);
        MeasurementMap.Builder builder = MeasurementMap.builder().put(latencyMetric, (double)roundtripNanos / 1000000.0).put(wireBytesSentMetric, (double)this.wireBytesSent).put(wireBytesReceivedMetric, (double)this.wireBytesReceived).put(uncompressedBytesSentMetric, (double)this.uncompressedBytesSent).put(uncompressedBytesReceivedMetric, (double)this.uncompressedBytesReceived);
        if (!status.isOk()) {
            builder.put(errorCountMetric, 1.0);
        }
        if (this.side == Side.CLIENT && this.clientPendingNanos >= 0L) {
            builder.put(RpcConstants.RPC_CLIENT_SERVER_ELAPSED_TIME, (double)(roundtripNanos - this.clientPendingNanos) / 1000000.0);
        }
        this.statsCtx.with(RpcConstants.RPC_STATUS, TagValue.create((String)status.getCode().toString())).record(builder.build());
    }

    private static enum Side {
        CLIENT,
        SERVER;

    }
}

