/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.netty;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.netty.handler.codec.http2.Http2SecurityUtil;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.ApplicationProtocolNegotiator;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.beam.repackaged.beam_runners_direct_java.com.google.common.base.Preconditions;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.netty.JettyTlsUtil;

public class GrpcSslContexts {
    private static final String GRPC_EXP_VERSION = "grpc-exp";
    private static final String HTTP2_VERSION = "h2";
    static final List<String> NEXT_PROTOCOL_VERSIONS = Collections.unmodifiableList(Arrays.asList("grpc-exp", "h2"));
    private static final ApplicationProtocolConfig ALPN = new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, NEXT_PROTOCOL_VERSIONS);
    private static final ApplicationProtocolConfig NPN = new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.NPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, NEXT_PROTOCOL_VERSIONS);
    private static final ApplicationProtocolConfig NPN_AND_ALPN = new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.NPN_AND_ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, NEXT_PROTOCOL_VERSIONS);

    private GrpcSslContexts() {
    }

    public static SslContextBuilder forClient() {
        return GrpcSslContexts.configure(SslContextBuilder.forClient());
    }

    public static SslContextBuilder forServer(File keyCertChainFile, File keyFile) {
        return GrpcSslContexts.configure(SslContextBuilder.forServer((File)keyCertChainFile, (File)keyFile));
    }

    public static SslContextBuilder forServer(File keyCertChainFile, File keyFile, String keyPassword) {
        return GrpcSslContexts.configure(SslContextBuilder.forServer((File)keyCertChainFile, (File)keyFile, (String)keyPassword));
    }

    @CanIgnoreReturnValue
    public static SslContextBuilder configure(SslContextBuilder builder) {
        return GrpcSslContexts.configure(builder, GrpcSslContexts.defaultSslProvider());
    }

    @CanIgnoreReturnValue
    public static SslContextBuilder configure(SslContextBuilder builder, SslProvider provider) {
        return builder.sslProvider(provider).ciphers((Iterable)Http2SecurityUtil.CIPHERS, (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE).applicationProtocolConfig(GrpcSslContexts.selectApplicationProtocolConfig(provider));
    }

    private static SslProvider defaultSslProvider() {
        return OpenSsl.isAvailable() ? SslProvider.OPENSSL : SslProvider.JDK;
    }

    private static ApplicationProtocolConfig selectApplicationProtocolConfig(SslProvider provider) {
        switch (provider) {
            case JDK: {
                if (JettyTlsUtil.isJettyAlpnConfigured()) {
                    return ALPN;
                }
                if (JettyTlsUtil.isJettyNpnConfigured()) {
                    return NPN;
                }
                throw new IllegalArgumentException("Jetty ALPN/NPN has not been properly configured.");
            }
            case OPENSSL: {
                if (!OpenSsl.isAvailable()) {
                    throw new IllegalArgumentException("OpenSSL is not installed on the system.");
                }
                if (OpenSsl.isAlpnSupported()) {
                    return NPN_AND_ALPN;
                }
                return NPN;
            }
        }
        throw new IllegalArgumentException("Unsupported provider: " + provider);
    }

    static void ensureAlpnAndH2Enabled(ApplicationProtocolNegotiator alpnNegotiator) {
        Preconditions.checkArgument(alpnNegotiator != null, "ALPN must be configured");
        Preconditions.checkArgument(alpnNegotiator.protocols() != null && !alpnNegotiator.protocols().isEmpty(), "ALPN must be enabled and list HTTP/2 as a supported protocol.");
        Preconditions.checkArgument(alpnNegotiator.protocols().contains(HTTP2_VERSION), "This ALPN config does not support HTTP/2. Expected %s, but got %s'.", new Object[]{HTTP2_VERSION, alpnNegotiator.protocols()});
    }
}

