/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.util.AsciiString;
import io.netty.util.concurrent.GenericFutureListener;
import javax.annotation.Nullable;
import org.apache.beam.repackaged.beam_runners_direct_java.com.google.common.base.Preconditions;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.Attributes;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.InternalKnownTransport;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.InternalMethodDescriptor;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.Metadata;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.MethodDescriptor;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.Status;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal.AbstractClientStream2;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal.ClientStreamListener;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal.GrpcUtil;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal.Http2ClientStreamTransportState;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal.StatsTraceContext;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal.WritableBuffer;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.netty.CancelClientStreamCommand;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.netty.CreateStreamCommand;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.netty.NettyClientHandler;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.netty.NettyReadableBuffer;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.netty.NettyWritableBuffer;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.netty.NettyWritableBufferAllocator;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.netty.SendGrpcFrameCommand;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.netty.StreamIdHolder;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.netty.Utils;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.netty.WriteQueue;

class NettyClientStream
extends AbstractClientStream2 {
    private static final InternalMethodDescriptor methodDescriptorAccessor = new InternalMethodDescriptor(InternalKnownTransport.NETTY);
    private final Sink sink = new Sink();
    private final TransportState state;
    private final WriteQueue writeQueue;
    private final MethodDescriptor<?, ?> method;
    private Metadata headers;
    private final Channel channel;
    private AsciiString authority;
    private final AsciiString scheme;
    private final AsciiString userAgent;

    NettyClientStream(TransportState state, MethodDescriptor<?, ?> method, Metadata headers, Channel channel, AsciiString authority, AsciiString scheme, AsciiString userAgent, StatsTraceContext statsTraceCtx) {
        super(new NettyWritableBufferAllocator(channel.alloc()), statsTraceCtx);
        this.state = Preconditions.checkNotNull(state, "transportState");
        this.writeQueue = state.handler.getWriteQueue();
        this.method = Preconditions.checkNotNull(method, "method");
        this.headers = Preconditions.checkNotNull(headers, "headers");
        this.channel = Preconditions.checkNotNull(channel, "channel");
        this.authority = Preconditions.checkNotNull(authority, "authority");
        this.scheme = Preconditions.checkNotNull(scheme, "scheme");
        this.userAgent = userAgent;
    }

    @Override
    protected TransportState transportState() {
        return this.state;
    }

    @Override
    protected Sink abstractClientStreamSink() {
        return this.sink;
    }

    @Override
    public void setAuthority(String authority) {
        Preconditions.checkState(this.headers != null, "must be call before start");
        this.authority = AsciiString.of((CharSequence)Preconditions.checkNotNull(authority, "authority"));
    }

    @Override
    public void start(ClientStreamListener listener) {
        super.start(listener);
        AsciiString defaultPath = (AsciiString)methodDescriptorAccessor.geRawMethodName(this.method);
        if (defaultPath == null) {
            defaultPath = new AsciiString((CharSequence)("/" + this.method.getFullMethodName()));
            methodDescriptorAccessor.setRawMethodName(this.method, defaultPath);
        }
        this.headers.discardAll(GrpcUtil.USER_AGENT_KEY);
        Http2Headers http2Headers = Utils.convertClientHeaders(this.headers, this.scheme, defaultPath, this.authority, this.userAgent);
        this.headers = null;
        ChannelFutureListener failureListener = new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    Status s = NettyClientStream.this.transportState().statusFromFailedFuture(future);
                    NettyClientStream.this.transportState().transportReportStatus(s, true, new Metadata());
                }
            }
        };
        this.writeQueue.enqueue(new CreateStreamCommand(http2Headers, this.transportState()), !this.method.getType().clientSendsOneMessage()).addListener((GenericFutureListener)failureListener);
    }

    @Override
    public Attributes getAttributes() {
        return this.state.handler.getAttributes();
    }

    public static abstract class TransportState
    extends Http2ClientStreamTransportState
    implements StreamIdHolder {
        private final NettyClientHandler handler;
        private int id;
        private Http2Stream http2Stream;

        public TransportState(NettyClientHandler handler, int maxMessageSize, StatsTraceContext statsTraceCtx) {
            super(maxMessageSize, statsTraceCtx);
            this.handler = Preconditions.checkNotNull(handler, "handler");
        }

        @Override
        public int id() {
            return this.id;
        }

        public void setId(int id) {
            Preconditions.checkArgument(id > 0, "id must be positive");
            this.id = id;
        }

        public void setHttp2Stream(Http2Stream http2Stream) {
            Preconditions.checkNotNull(http2Stream, "http2Stream");
            Preconditions.checkState(this.http2Stream == null, "Can only set http2Stream once");
            this.http2Stream = http2Stream;
            this.onStreamAllocated();
        }

        @Nullable
        public Http2Stream http2Stream() {
            return this.http2Stream;
        }

        protected abstract Status statusFromFailedFuture(ChannelFuture var1);

        @Override
        protected void http2ProcessingFailed(Status status, Metadata trailers) {
            this.transportReportStatus(status, false, trailers);
            this.handler.getWriteQueue().enqueue(new CancelClientStreamCommand(this, status), true);
        }

        @Override
        public void bytesRead(int processedBytes) {
            this.handler.returnProcessedBytes(this.http2Stream, processedBytes);
            this.handler.getWriteQueue().scheduleFlush();
        }

        @Override
        protected void deframeFailed(Throwable cause) {
            this.http2ProcessingFailed(Status.fromThrowable(cause), new Metadata());
        }

        void transportHeadersReceived(Http2Headers headers, boolean endOfStream) {
            if (endOfStream) {
                this.transportTrailersReceived(Utils.convertTrailers(headers));
            } else {
                this.transportHeadersReceived(Utils.convertHeaders(headers));
            }
        }

        void transportDataReceived(ByteBuf frame, boolean endOfStream) {
            this.transportDataReceived(new NettyReadableBuffer(frame.retain()), endOfStream);
        }
    }

    private class Sink
    implements AbstractClientStream2.Sink {
        private Sink() {
        }

        @Override
        public void writeFrame(WritableBuffer frame, boolean endOfStream, boolean flush) {
            ByteBuf bytebuf = frame == null ? Unpooled.EMPTY_BUFFER : ((NettyWritableBuffer)frame).bytebuf();
            final int numBytes = bytebuf.readableBytes();
            if (numBytes > 0) {
                NettyClientStream.this.onSendingBytes(numBytes);
                NettyClientStream.this.writeQueue.enqueue(new SendGrpcFrameCommand(NettyClientStream.this.transportState(), bytebuf, endOfStream), NettyClientStream.this.channel.newPromise().addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        if (future.isSuccess()) {
                            NettyClientStream.this.transportState().onSentBytes(numBytes);
                        }
                    }
                }), flush);
            } else {
                NettyClientStream.this.writeQueue.enqueue(new SendGrpcFrameCommand(NettyClientStream.this.transportState(), bytebuf, endOfStream), flush);
            }
        }

        @Override
        public void request(final int numMessages) {
            if (NettyClientStream.this.channel.eventLoop().inEventLoop()) {
                NettyClientStream.this.transportState().requestMessagesFromDeframer(numMessages);
            } else {
                NettyClientStream.this.channel.eventLoop().execute(new Runnable(){

                    @Override
                    public void run() {
                        NettyClientStream.this.transportState().requestMessagesFromDeframer(numMessages);
                    }
                });
            }
        }

        @Override
        public void cancel(Status status) {
            NettyClientStream.this.writeQueue.enqueue(new CancelClientStreamCommand(NettyClientStream.this.transportState(), status), true);
        }
    }
}

