/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.beam.repackaged.beam_runners_direct_java.com.google.common.base.Preconditions;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.Attributes;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.Metadata;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.Status;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal.AbstractServerStream;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal.StatsTraceContext;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal.WritableBuffer;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.netty.CancelServerStreamCommand;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.netty.NettyReadableBuffer;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.netty.NettyServerHandler;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.netty.NettyWritableBuffer;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.netty.NettyWritableBufferAllocator;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.netty.SendGrpcFrameCommand;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.netty.SendResponseHeadersCommand;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.netty.StreamIdHolder;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.netty.Utils;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.netty.WriteQueue;

class NettyServerStream
extends AbstractServerStream {
    private static final Logger log = Logger.getLogger(NettyServerStream.class.getName());
    private final Sink sink = new Sink();
    private final TransportState state;
    private final Channel channel;
    private final WriteQueue writeQueue;
    private final Attributes attributes;
    private final String authority;

    public NettyServerStream(Channel channel, TransportState state, Attributes transportAttrs, String authority, StatsTraceContext statsTraceCtx) {
        super(new NettyWritableBufferAllocator(channel.alloc()), statsTraceCtx);
        this.state = Preconditions.checkNotNull(state, "transportState");
        this.channel = Preconditions.checkNotNull(channel, "channel");
        this.writeQueue = state.handler.getWriteQueue();
        this.attributes = Preconditions.checkNotNull(transportAttrs);
        this.authority = authority;
    }

    @Override
    protected TransportState transportState() {
        return this.state;
    }

    @Override
    protected Sink abstractServerStreamSink() {
        return this.sink;
    }

    @Override
    public Attributes getAttributes() {
        return this.attributes;
    }

    @Override
    public String getAuthority() {
        return this.authority;
    }

    public static class TransportState
    extends AbstractServerStream.TransportState
    implements StreamIdHolder {
        private final Http2Stream http2Stream;
        private final NettyServerHandler handler;

        public TransportState(NettyServerHandler handler, Http2Stream http2Stream, int maxMessageSize, StatsTraceContext statsTraceCtx) {
            super(maxMessageSize, statsTraceCtx);
            this.http2Stream = Preconditions.checkNotNull(http2Stream, "http2Stream");
            this.handler = Preconditions.checkNotNull(handler, "handler");
        }

        @Override
        public void bytesRead(int processedBytes) {
            this.handler.returnProcessedBytes(this.http2Stream, processedBytes);
            this.handler.getWriteQueue().scheduleFlush();
        }

        @Override
        protected void deframeFailed(Throwable cause) {
            log.log(Level.WARNING, "Exception processing message", cause);
            Status status = Status.fromThrowable(cause);
            this.transportReportStatus(status);
            this.handler.getWriteQueue().enqueue(new CancelServerStreamCommand(this, status), true);
        }

        void inboundDataReceived(ByteBuf frame, boolean endOfStream) {
            super.inboundDataReceived(new NettyReadableBuffer(frame.retain()), endOfStream);
        }

        @Override
        public int id() {
            return this.http2Stream.id();
        }
    }

    private class Sink
    implements AbstractServerStream.Sink {
        private Sink() {
        }

        @Override
        public void request(final int numMessages) {
            if (NettyServerStream.this.channel.eventLoop().inEventLoop()) {
                NettyServerStream.this.transportState().requestMessagesFromDeframer(numMessages);
            } else {
                NettyServerStream.this.channel.eventLoop().execute(new Runnable(){

                    @Override
                    public void run() {
                        NettyServerStream.this.transportState().requestMessagesFromDeframer(numMessages);
                    }
                });
            }
        }

        @Override
        public void writeHeaders(Metadata headers) {
            NettyServerStream.this.writeQueue.enqueue(new SendResponseHeadersCommand(NettyServerStream.this.transportState(), Utils.convertServerHeaders(headers), false), true);
        }

        @Override
        public void writeFrame(WritableBuffer frame, boolean flush) {
            if (frame == null) {
                NettyServerStream.this.writeQueue.scheduleFlush();
                return;
            }
            ByteBuf bytebuf = ((NettyWritableBuffer)frame).bytebuf();
            final int numBytes = bytebuf.readableBytes();
            NettyServerStream.this.onSendingBytes(numBytes);
            NettyServerStream.this.writeQueue.enqueue(new SendGrpcFrameCommand(NettyServerStream.this.transportState(), bytebuf, false), NettyServerStream.this.channel.newPromise().addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    NettyServerStream.this.transportState().onSentBytes(numBytes);
                }
            }), flush);
        }

        @Override
        public void writeTrailers(Metadata trailers, boolean headersSent) {
            Http2Headers http2Trailers = Utils.convertTrailers(trailers, headersSent);
            NettyServerStream.this.writeQueue.enqueue(new SendResponseHeadersCommand(NettyServerStream.this.transportState(), http2Trailers, true), true);
        }

        @Override
        public void cancel(Status status) {
            NettyServerStream.this.writeQueue.enqueue(new CancelServerStreamCommand(NettyServerStream.this.transportState(), status), true);
        }
    }
}

