/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.beam.repackaged.beam_runners_direct_java.com.google.common.base.Preconditions;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.Status;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal.LogId;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal.ServerTransport;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal.ServerTransportListener;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.netty.ForcefulCloseCommand;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.netty.HandlerSettings;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.netty.NettyServerHandler;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.netty.ProtocolNegotiator;

class NettyServerTransport
implements ServerTransport {
    private static final Logger log = Logger.getLogger(NettyServerTransport.class.getName());
    private final LogId logId = LogId.allocate(this.getClass().getName());
    private final Channel channel;
    private final ProtocolNegotiator protocolNegotiator;
    private final int maxStreams;
    private ServerTransportListener listener;
    private boolean terminated;
    private final int flowControlWindow;
    private final int maxMessageSize;
    private final int maxHeaderListSize;

    NettyServerTransport(Channel channel, ProtocolNegotiator protocolNegotiator, int maxStreams, int flowControlWindow, int maxMessageSize, int maxHeaderListSize) {
        this.channel = Preconditions.checkNotNull(channel, "channel");
        this.protocolNegotiator = Preconditions.checkNotNull(protocolNegotiator, "protocolNegotiator");
        this.maxStreams = maxStreams;
        this.flowControlWindow = flowControlWindow;
        this.maxMessageSize = maxMessageSize;
        this.maxHeaderListSize = maxHeaderListSize;
    }

    public void start(ServerTransportListener listener) {
        Preconditions.checkState(this.listener == null, "Handler already registered");
        this.listener = listener;
        final NettyServerHandler grpcHandler = this.createHandler(listener);
        HandlerSettings.setAutoWindow(grpcHandler);
        this.channel.closeFuture().addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                NettyServerTransport.this.notifyTerminated(grpcHandler.connectionError());
            }
        });
        ProtocolNegotiator.Handler negotiationHandler = this.protocolNegotiator.newHandler(grpcHandler);
        this.channel.pipeline().addLast(new ChannelHandler[]{negotiationHandler});
    }

    @Override
    public void shutdown() {
        if (this.channel.isOpen()) {
            this.channel.close();
        }
    }

    @Override
    public void shutdownNow(Status reason) {
        if (this.channel.isOpen()) {
            this.channel.writeAndFlush((Object)new ForcefulCloseCommand(reason));
        }
    }

    @Override
    public LogId getLogId() {
        return this.logId;
    }

    Channel channel() {
        return this.channel;
    }

    private void notifyTerminated(Throwable t) {
        if (t != null) {
            log.log(Level.SEVERE, "Transport failed", t);
        }
        if (!this.terminated) {
            this.terminated = true;
            this.listener.transportTerminated();
        }
    }

    private NettyServerHandler createHandler(ServerTransportListener transportListener) {
        return NettyServerHandler.newHandler(transportListener, this.maxStreams, this.flowControlWindow, this.maxHeaderListSize, this.maxMessageSize);
    }
}

