/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.protobuf;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import org.apache.beam.repackaged.beam_runners_direct_java.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.beam.repackaged.beam_runners_direct_java.com.google.protobuf.Message;
import org.apache.beam.repackaged.beam_runners_direct_java.com.google.protobuf.MessageOrBuilder;
import org.apache.beam.repackaged.beam_runners_direct_java.com.google.protobuf.util.JsonFormat;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.Metadata;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.MethodDescriptor;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.Status;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.protobuf.lite.ProtoLiteUtils;

public class ProtoUtils {
    public static <T extends Message> MethodDescriptor.Marshaller<T> marshaller(T defaultInstance) {
        return ProtoLiteUtils.marshaller(defaultInstance);
    }

    public static <T extends Message> MethodDescriptor.Marshaller<T> jsonMarshaller(T defaultInstance) {
        JsonFormat.Parser parser = JsonFormat.parser();
        JsonFormat.Printer printer = JsonFormat.printer();
        return ProtoUtils.jsonMarshaller(defaultInstance, parser, printer);
    }

    public static <T extends Message> MethodDescriptor.Marshaller<T> jsonMarshaller(final T defaultInstance, final JsonFormat.Parser parser, final JsonFormat.Printer printer) {
        final Charset charset = Charset.forName("UTF-8");
        return new MethodDescriptor.Marshaller<T>(){

            @Override
            public InputStream stream(T value) {
                try {
                    return new ByteArrayInputStream(printer.print((MessageOrBuilder)value).getBytes(charset));
                }
                catch (InvalidProtocolBufferException e) {
                    throw Status.INTERNAL.withCause(e).withDescription("Unable to print json proto").asRuntimeException();
                }
            }

            @Override
            public T parse(InputStream stream) {
                Message proto;
                Message.Builder builder = defaultInstance.newBuilderForType();
                InputStreamReader reader = new InputStreamReader(stream, charset);
                try {
                    parser.merge(reader, builder);
                    proto = builder.build();
                    ((Reader)reader).close();
                }
                catch (InvalidProtocolBufferException e) {
                    throw Status.INTERNAL.withDescription("Invalid protobuf byte sequence").withCause(e).asRuntimeException();
                }
                catch (IOException e) {
                    throw Status.INTERNAL.withDescription("Invalid protobuf byte sequence").withCause(e).asRuntimeException();
                }
                return proto;
            }
        };
    }

    public static <T extends Message> Metadata.Key<T> keyForProto(T instance) {
        return Metadata.Key.of(instance.getDescriptorForType().getFullName() + "-bin", ProtoLiteUtils.metadataMarshaller(instance));
    }

    private ProtoUtils() {
    }
}

