/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.protobuf.lite;

import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.apache.beam.repackaged.beam_runners_direct_java.com.google.common.base.Preconditions;
import org.apache.beam.repackaged.beam_runners_direct_java.com.google.protobuf.CodedInputStream;
import org.apache.beam.repackaged.beam_runners_direct_java.com.google.protobuf.ExtensionRegistryLite;
import org.apache.beam.repackaged.beam_runners_direct_java.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.beam.repackaged.beam_runners_direct_java.com.google.protobuf.MessageLite;
import org.apache.beam.repackaged.beam_runners_direct_java.com.google.protobuf.Parser;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.KnownLength;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.Metadata;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.MethodDescriptor;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.Status;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.protobuf.lite.ProtoInputStream;

public class ProtoLiteUtils {
    private static volatile ExtensionRegistryLite globalRegistry = ExtensionRegistryLite.getEmptyRegistry();
    private static final ThreadLocal<Reference<byte[]>> bufs = new ThreadLocal<Reference<byte[]>>(){

        @Override
        protected Reference<byte[]> initialValue() {
            return new WeakReference<byte[]>(new byte[4096]);
        }
    };

    public static void setExtensionRegistry(ExtensionRegistryLite newRegistry) {
        globalRegistry = Preconditions.checkNotNull(newRegistry, "newRegistry");
    }

    public static <T extends MessageLite> MethodDescriptor.Marshaller<T> marshaller(final T defaultInstance) {
        final Parser<? extends MessageLite> parser = defaultInstance.getParserForType();
        return new MethodDescriptor.PrototypeMarshaller<T>(){

            @Override
            public Class<T> getMessageClass() {
                return defaultInstance.getClass();
            }

            @Override
            public T getMessagePrototype() {
                return defaultInstance;
            }

            @Override
            public InputStream stream(T value) {
                return new ProtoInputStream((MessageLite)value, parser);
            }

            @Override
            public T parse(InputStream stream) {
                ProtoInputStream protoStream;
                if (stream instanceof ProtoInputStream && (protoStream = (ProtoInputStream)stream).parser() == parser) {
                    try {
                        MessageLite message = ((ProtoInputStream)stream).message();
                        return message;
                    }
                    catch (IllegalStateException message) {
                        // empty catch block
                    }
                }
                CodedInputStream cis = null;
                try {
                    if (stream instanceof KnownLength) {
                        int size = stream.available();
                        if (size > 0 && size <= 0x400000) {
                            int chunkSize;
                            byte[] buf = (byte[])((Reference)bufs.get()).get();
                            if (buf == null || buf.length < size) {
                                buf = new byte[size];
                                bufs.set(new WeakReference<byte[]>(buf));
                            }
                            int position = 0;
                            while ((chunkSize = stream.read(buf, position, size - position)) != -1) {
                                position += chunkSize;
                            }
                            if (size != position) {
                                throw new RuntimeException("size inaccurate: " + size + " != " + position);
                            }
                            cis = CodedInputStream.newInstance(buf, 0, size);
                        } else if (size == 0) {
                            return defaultInstance;
                        }
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                if (cis == null) {
                    cis = CodedInputStream.newInstance(stream);
                }
                cis.setSizeLimit(Integer.MAX_VALUE);
                try {
                    return this.parseFrom(cis);
                }
                catch (InvalidProtocolBufferException ipbe) {
                    throw Status.INTERNAL.withDescription("Invalid protobuf byte sequence").withCause(ipbe).asRuntimeException();
                }
            }

            private T parseFrom(CodedInputStream stream) throws InvalidProtocolBufferException {
                MessageLite message = (MessageLite)parser.parseFrom(stream, globalRegistry);
                try {
                    stream.checkLastTagWas(0);
                    return message;
                }
                catch (InvalidProtocolBufferException e) {
                    e.setUnfinishedMessage(message);
                    throw e;
                }
            }
        };
    }

    public static <T extends MessageLite> Metadata.BinaryMarshaller<T> metadataMarshaller(final T instance) {
        return new Metadata.BinaryMarshaller<T>(){

            @Override
            public byte[] toBytes(T value) {
                return value.toByteArray();
            }

            @Override
            public T parseBytes(byte[] serialized) {
                try {
                    return instance.getParserForType().parseFrom(serialized, globalRegistry);
                }
                catch (InvalidProtocolBufferException ipbe) {
                    throw new IllegalArgumentException(ipbe);
                }
            }
        };
    }

    private ProtoLiteUtils() {
    }
}

