/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.stub;

import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.beam.repackaged.beam_runners_direct_java.com.google.common.base.Preconditions;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.CallCredentials;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.CallOptions;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.Channel;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.ClientInterceptor;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.ClientInterceptors;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.Deadline;

public abstract class AbstractStub<S extends AbstractStub<S>> {
    private final Channel channel;
    private final CallOptions callOptions;

    protected AbstractStub(Channel channel) {
        this(channel, CallOptions.DEFAULT);
    }

    protected AbstractStub(Channel channel, CallOptions callOptions) {
        this.channel = Preconditions.checkNotNull(channel, "channel");
        this.callOptions = Preconditions.checkNotNull(callOptions, "callOptions");
    }

    public final Channel getChannel() {
        return this.channel;
    }

    public final CallOptions getCallOptions() {
        return this.callOptions;
    }

    protected abstract S build(Channel var1, CallOptions var2);

    public final S withDeadline(@Nullable Deadline deadline) {
        return this.build(this.channel, this.callOptions.withDeadline(deadline));
    }

    public final S withDeadlineAfter(long duration, TimeUnit unit) {
        return this.build(this.channel, this.callOptions.withDeadlineAfter(duration, unit));
    }

    public final S withCompression(String compressorName) {
        return this.build(this.channel, this.callOptions.withCompression(compressorName));
    }

    public final S withChannel(Channel newChannel) {
        return this.build(newChannel, this.callOptions);
    }

    public final <T> S withOption(CallOptions.Key<T> key, T value) {
        return this.build(this.channel, this.callOptions.withOption(key, value));
    }

    public final S withInterceptors(ClientInterceptor ... interceptors) {
        return this.build(ClientInterceptors.intercept(this.channel, interceptors), this.callOptions);
    }

    public final S withCallCredentials(CallCredentials credentials) {
        return this.build(this.channel, this.callOptions.withCallCredentials(credentials));
    }

    public final S withWaitForReady() {
        return this.build(this.channel, this.callOptions.withWaitForReady());
    }

    public final S withMaxInboundMessageSize(int maxSize) {
        return this.build(this.channel, this.callOptions.withMaxInboundMessageSize(maxSize));
    }

    public final S withMaxOutboundMessageSize(int maxSize) {
        return this.build(this.channel, this.callOptions.withMaxOutboundMessageSize(maxSize));
    }
}

