/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.stub;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.CallOptions;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.Channel;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.ClientCall;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.ClientInterceptor;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.ForwardingClientCall;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.ForwardingClientCallListener;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.Metadata;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.MethodDescriptor;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.Status;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.stub.AbstractStub;

public final class MetadataUtils {
    private MetadataUtils() {
    }

    public static <T extends AbstractStub<T>> T attachHeaders(T stub, Metadata extraHeaders) {
        return stub.withInterceptors(MetadataUtils.newAttachHeadersInterceptor(extraHeaders));
    }

    public static ClientInterceptor newAttachHeadersInterceptor(final Metadata extraHeaders) {
        return new ClientInterceptor(){

            @Override
            public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
                return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

                    @Override
                    public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                        headers.merge(extraHeaders);
                        super.start(responseListener, headers);
                    }
                };
            }
        };
    }

    public static <T extends AbstractStub<T>> T captureMetadata(T stub, AtomicReference<Metadata> headersCapture, AtomicReference<Metadata> trailersCapture) {
        return stub.withInterceptors(MetadataUtils.newCaptureMetadataInterceptor(headersCapture, trailersCapture));
    }

    public static ClientInterceptor newCaptureMetadataInterceptor(final AtomicReference<Metadata> headersCapture, final AtomicReference<Metadata> trailersCapture) {
        return new ClientInterceptor(){

            @Override
            public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
                return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

                    @Override
                    public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                        headersCapture.set(null);
                        trailersCapture.set(null);
                        super.start(new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                            @Override
                            public void onHeaders(Metadata headers) {
                                headersCapture.set(headers);
                                super.onHeaders(headers);
                            }

                            @Override
                            public void onClose(Status status, Metadata trailers) {
                                trailersCapture.set(trailers);
                                super.onClose(status, trailers);
                            }
                        }, headers);
                    }
                };
            }
        };
    }
}

