/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.stub;

import java.util.Iterator;
import org.apache.beam.repackaged.beam_runners_direct_java.com.google.common.base.Preconditions;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.stub.CallStreamObserver;

public final class StreamObservers {
    public static <V> void copyWithFlowControl(final Iterator<V> source, final CallStreamObserver<V> target) {
        Preconditions.checkNotNull(source, "source");
        Preconditions.checkNotNull(target, "target");
        target.setOnReadyHandler(new Runnable(){

            @Override
            public void run() {
                while (target.isReady() && source.hasNext()) {
                    target.onNext(source.next());
                }
                if (!source.hasNext()) {
                    target.onCompleted();
                }
            }
        });
    }

    public static <V> void copyWithFlowControl(Iterable<V> source, CallStreamObserver<V> target) {
        Preconditions.checkNotNull(source, "source");
        StreamObservers.copyWithFlowControl(source.iterator(), target);
    }
}

