/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction;

import java.util.Collections;
import java.util.List;
import org.apache.beam.repackaged.beam_runners_core_construction_java.com.google.common.collect.ImmutableList;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.CoderTranslator;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.LengthPrefixCoder;
import org.apache.beam.sdk.util.InstanceBuilder;
import org.apache.beam.sdk.util.WindowedValue;

class CoderTranslators {
    private CoderTranslators() {
    }

    static <T extends Coder<?>> CoderTranslator<T> atomic(final Class<T> clazz) {
        return new SimpleStructuredCoderTranslator<T>(){

            @Override
            public List<? extends Coder<?>> getComponents(T from) {
                return Collections.emptyList();
            }

            @Override
            public T fromComponents(List<Coder<?>> components) {
                return (Coder)InstanceBuilder.ofType((Class)clazz).build();
            }
        };
    }

    static CoderTranslator<KvCoder<?, ?>> kv() {
        return new SimpleStructuredCoderTranslator<KvCoder<?, ?>>(){

            @Override
            public List<? extends Coder<?>> getComponents(KvCoder<?, ?> from) {
                return ImmutableList.of(from.getKeyCoder(), from.getValueCoder());
            }

            @Override
            public KvCoder<?, ?> fromComponents(List<Coder<?>> components) {
                return KvCoder.of(components.get(0), components.get(1));
            }
        };
    }

    static CoderTranslator<IterableCoder<?>> iterable() {
        return new SimpleStructuredCoderTranslator<IterableCoder<?>>(){

            @Override
            public List<? extends Coder<?>> getComponents(IterableCoder<?> from) {
                return Collections.singletonList(from.getElemCoder());
            }

            @Override
            public IterableCoder<?> fromComponents(List<Coder<?>> components) {
                return IterableCoder.of(components.get(0));
            }
        };
    }

    static CoderTranslator<LengthPrefixCoder<?>> lengthPrefix() {
        return new SimpleStructuredCoderTranslator<LengthPrefixCoder<?>>(){

            @Override
            public List<? extends Coder<?>> getComponents(LengthPrefixCoder<?> from) {
                return Collections.singletonList(from.getValueCoder());
            }

            @Override
            public LengthPrefixCoder<?> fromComponents(List<Coder<?>> components) {
                return LengthPrefixCoder.of(components.get(0));
            }
        };
    }

    static CoderTranslator<WindowedValue.FullWindowedValueCoder<?>> fullWindowedValue() {
        return new SimpleStructuredCoderTranslator<WindowedValue.FullWindowedValueCoder<?>>(){

            @Override
            public List<? extends Coder<?>> getComponents(WindowedValue.FullWindowedValueCoder<?> from) {
                return ImmutableList.of(from.getValueCoder(), from.getWindowCoder());
            }

            @Override
            public WindowedValue.FullWindowedValueCoder<?> fromComponents(List<Coder<?>> components) {
                return WindowedValue.getFullCoder(components.get(0), components.get(1));
            }
        };
    }

    public static abstract class SimpleStructuredCoderTranslator<T extends Coder<?>>
    implements CoderTranslator<T> {
        @Override
        public final T fromComponents(List<Coder<?>> components, byte[] payload) {
            return this.fromComponents(components);
        }

        protected abstract T fromComponents(List<Coder<?>> var1);
    }
}

