/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction;

import com.google.auto.service.AutoService;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.beam.repackaged.beam_runners_core_construction_java.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.repackaged.beam_runners_core_construction_java.com.google.common.base.Preconditions;
import org.apache.beam.repackaged.beam_runners_core_construction_java.com.google.common.collect.Iterables;
import org.apache.beam.repackaged.beam_runners_direct_java.com.google.protobuf.ByteString;
import org.apache.beam.repackaged.beam_runners_direct_java.model.pipeline.v1.RunnerApi;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.CoderTranslation;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.Environments;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.PTransformTranslation;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.RehydratedComponents;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.SdkComponents;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.TransformInputs;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.TransformPayloadTranslatorRegistrar;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.CombineFnBase;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.util.AppliedCombineFn;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.WindowingStrategy;

public class CombineTranslation {
    public static final String JAVA_SERIALIZED_COMBINE_FN_URN = "urn:beam:combinefn:javasdk:v1";

    static RunnerApi.CombinePayload payloadForCombineLike(CombineLike combine, SdkComponents components) throws IOException {
        return RunnerApi.CombinePayload.newBuilder().setAccumulatorCoderId(components.registerCoder(combine.getAccumulatorCoder())).setCombineFn(combine.getCombineFn()).build();
    }

    static <K, InputT, OutputT> RunnerApi.CombinePayload payloadForCombine(final AppliedPTransform<PCollection<KV<K, InputT>>, PCollection<KV<K, OutputT>>, Combine.PerKey<K, InputT, OutputT>> combine, final SdkComponents components) throws IOException {
        return CombineTranslation.payloadForCombineLike(new CombineLike(){

            @Override
            public RunnerApi.SdkFunctionSpec getCombineFn() {
                return RunnerApi.SdkFunctionSpec.newBuilder().setEnvironmentId(components.registerEnvironment(Environments.JAVA_SDK_HARNESS_ENVIRONMENT)).setSpec(RunnerApi.FunctionSpec.newBuilder().setUrn(CombineTranslation.JAVA_SERIALIZED_COMBINE_FN_URN).setPayload(ByteString.copyFrom(SerializableUtils.serializeToByteArray((Serializable)((Combine.PerKey)combine.getTransform()).getFn()))).build()).build();
            }

            @Override
            public Coder<?> getAccumulatorCoder() {
                CombineFnBase.GlobalCombineFn combineFn = ((Combine.PerKey)combine.getTransform()).getFn();
                try {
                    return CombineTranslation.extractAccumulatorCoder(combineFn, combine);
                }
                catch (CannotProvideCoderException e) {
                    throw new IllegalStateException(e);
                }
            }
        }, components);
    }

    @VisibleForTesting
    static RunnerApi.CombinePayload toProto(AppliedPTransform<?, ?, Combine.PerKey<?, ?, ?>> combine, SdkComponents sdkComponents) throws IOException {
        Preconditions.checkArgument(((Combine.PerKey)combine.getTransform()).getSideInputs().isEmpty(), "CombineTranslation.toProto cannot translate Combines with side inputs.");
        CombineFnBase.GlobalCombineFn combineFn = ((Combine.PerKey)combine.getTransform()).getFn();
        try {
            Coder accumulatorCoder = CombineTranslation.extractAccumulatorCoder(combineFn, combine);
            return RunnerApi.CombinePayload.newBuilder().setAccumulatorCoderId(sdkComponents.registerCoder(accumulatorCoder)).setCombineFn(CombineTranslation.toProto(combineFn, sdkComponents)).build();
        }
        catch (CannotProvideCoderException e) {
            throw new IllegalStateException(e);
        }
    }

    private static <K, InputT, AccumT> Coder<AccumT> extractAccumulatorCoder(CombineFnBase.GlobalCombineFn<InputT, AccumT, ?> combineFn, AppliedPTransform<PCollection<KV<K, InputT>>, ?, Combine.PerKey<K, InputT, ?>> transform) throws CannotProvideCoderException {
        PCollection mainInput = (PCollection)Iterables.getOnlyElement(TransformInputs.nonAdditionalInputs(transform));
        KvCoder inputCoder = (KvCoder)mainInput.getCoder();
        return AppliedCombineFn.withInputCoder(combineFn, (CoderRegistry)transform.getPipeline().getCoderRegistry(), (KvCoder)inputCoder, (Iterable)((Combine.PerKey)transform.getTransform()).getSideInputs(), (WindowingStrategy)((PCollection)Iterables.getOnlyElement(transform.getOutputs().values())).getWindowingStrategy()).getAccumulatorCoder();
    }

    public static RunnerApi.SdkFunctionSpec toProto(CombineFnBase.GlobalCombineFn<?, ?, ?> combineFn, SdkComponents components) {
        return RunnerApi.SdkFunctionSpec.newBuilder().setEnvironmentId(components.registerEnvironment(Environments.JAVA_SDK_HARNESS_ENVIRONMENT)).setSpec(RunnerApi.FunctionSpec.newBuilder().setUrn(JAVA_SERIALIZED_COMBINE_FN_URN).setPayload(ByteString.copyFrom(SerializableUtils.serializeToByteArray(combineFn))).build()).build();
    }

    public static Coder<?> getAccumulatorCoder(RunnerApi.CombinePayload payload, RehydratedComponents components) throws IOException {
        String id = payload.getAccumulatorCoderId();
        return components.getCoder(id);
    }

    public static Coder<?> getAccumulatorCoder(AppliedPTransform<?, ?, ?> transform) throws IOException {
        SdkComponents sdkComponents = SdkComponents.create();
        String id = CombineTranslation.getCombinePayload(transform, sdkComponents).map(RunnerApi.CombinePayload::getAccumulatorCoderId).orElseThrow(() -> new IOException("Transform does not contain an AccumulatorCoder"));
        RunnerApi.Components components = sdkComponents.toComponents();
        return CoderTranslation.fromProto(components.getCodersOrThrow(id), RehydratedComponents.forComponents(components));
    }

    public static CombineFnBase.GlobalCombineFn<?, ?, ?> getCombineFn(RunnerApi.CombinePayload payload) throws IOException {
        Preconditions.checkArgument(payload.getCombineFn().getSpec().getUrn().equals(JAVA_SERIALIZED_COMBINE_FN_URN), "Payload URN was \"%s\", should have been \"%s\".", (Object)payload.getCombineFn().getSpec().getUrn(), (Object)JAVA_SERIALIZED_COMBINE_FN_URN);
        return (CombineFnBase.GlobalCombineFn)SerializableUtils.deserializeFromByteArray((byte[])payload.getCombineFn().getSpec().getPayload().toByteArray(), (String)"CombineFn");
    }

    public static Optional<CombineFnBase.GlobalCombineFn<?, ?, ?>> getCombineFn(AppliedPTransform<?, ?, ?> transform) throws IOException {
        Optional<RunnerApi.CombinePayload> payload = CombineTranslation.getCombinePayload(transform);
        if (payload.isPresent()) {
            return Optional.of(CombineTranslation.getCombineFn(payload.get()));
        }
        return Optional.empty();
    }

    private static Optional<RunnerApi.CombinePayload> getCombinePayload(AppliedPTransform<?, ?, ?> transform) throws IOException {
        return CombineTranslation.getCombinePayload(transform, SdkComponents.create());
    }

    private static Optional<RunnerApi.CombinePayload> getCombinePayload(AppliedPTransform<?, ?, ?> transform, SdkComponents components) throws IOException {
        RunnerApi.PTransform proto = PTransformTranslation.toProto(transform, Collections.emptyList(), components);
        if (proto.hasSpec()) {
            return Optional.of(RunnerApi.CombinePayload.parseFrom(proto.getSpec().getPayload()));
        }
        return Optional.empty();
    }

    private static class RawCombine<K, InputT, AccumT, OutputT>
    extends PTransformTranslation.RawPTransform<PCollection<KV<K, InputT>>, PCollection<KV<K, OutputT>>>
    implements CombineLike {
        private final RunnerApi.PTransform protoTransform;
        private final transient RehydratedComponents rehydratedComponents;
        private final RunnerApi.FunctionSpec spec;
        private final RunnerApi.CombinePayload payload;
        private final Coder<AccumT> accumulatorCoder;

        private RawCombine(RunnerApi.PTransform protoTransform, RehydratedComponents rehydratedComponents) throws IOException {
            this.protoTransform = protoTransform;
            this.rehydratedComponents = rehydratedComponents;
            this.spec = protoTransform.getSpec();
            this.payload = RunnerApi.CombinePayload.parseFrom(this.spec.getPayload());
            try {
                this.accumulatorCoder = rehydratedComponents.getCoder(this.payload.getAccumulatorCoderId());
            }
            catch (IOException exc) {
                throw new IllegalArgumentException(String.format("Failure extracting accumulator coder with id '%s' for %s", this.payload.getAccumulatorCoderId(), Combine.class.getSimpleName()), exc);
            }
        }

        @Override
        public String getUrn() {
            return PTransformTranslation.COMBINE_TRANSFORM_URN;
        }

        @Override
        @Nonnull
        public RunnerApi.FunctionSpec getSpec() {
            return this.spec;
        }

        @Override
        public RunnerApi.FunctionSpec migrate(SdkComponents sdkComponents) throws IOException {
            return RunnerApi.FunctionSpec.newBuilder().setUrn(PTransformTranslation.COMBINE_TRANSFORM_URN).setPayload(CombineTranslation.payloadForCombineLike(this, sdkComponents).toByteString()).build();
        }

        @Override
        public RunnerApi.SdkFunctionSpec getCombineFn() {
            return this.payload.getCombineFn();
        }

        @Override
        public Coder<?> getAccumulatorCoder() {
            return this.accumulatorCoder;
        }
    }

    static interface CombineLike {
        public RunnerApi.SdkFunctionSpec getCombineFn();

        public Coder<?> getAccumulatorCoder();
    }

    public static class CombinePayloadTranslator
    implements PTransformTranslation.TransformPayloadTranslator<Combine.PerKey<?, ?, ?>> {
        public static PTransformTranslation.TransformPayloadTranslator create() {
            return new CombinePayloadTranslator();
        }

        private CombinePayloadTranslator() {
        }

        @Override
        public String getUrn(Combine.PerKey<?, ?, ?> transform) {
            return PTransformTranslation.COMBINE_TRANSFORM_URN;
        }

        @Override
        public RunnerApi.FunctionSpec translate(AppliedPTransform<?, ?, Combine.PerKey<?, ?, ?>> transform, SdkComponents components) throws IOException {
            if (((Combine.PerKey)transform.getTransform()).getSideInputs().isEmpty()) {
                return RunnerApi.FunctionSpec.newBuilder().setUrn(PTransformTranslation.COMBINE_TRANSFORM_URN).setPayload(CombineTranslation.payloadForCombine(transform, components).toByteString()).build();
            }
            return null;
        }

        @Override
        public PTransformTranslation.RawPTransform<?, ?> rehydrate(RunnerApi.PTransform protoTransform, RehydratedComponents rehydratedComponents) throws IOException {
            Preconditions.checkArgument(protoTransform.getSpec() != null, "%s received transform with null spec", (Object)this.getClass().getSimpleName());
            Preconditions.checkArgument(protoTransform.getSpec().getUrn().equals(PTransformTranslation.COMBINE_TRANSFORM_URN));
            return new RawCombine(protoTransform, rehydratedComponents);
        }

        @AutoService(value=TransformPayloadTranslatorRegistrar.class)
        public static class Registrar
        implements TransformPayloadTranslatorRegistrar {
            @Override
            public Map<? extends Class<? extends PTransform>, ? extends PTransformTranslation.TransformPayloadTranslator> getTransformPayloadTranslators() {
                return Collections.singletonMap(Combine.PerKey.class, new CombinePayloadTranslator());
            }

            @Override
            public Map<String, ? extends PTransformTranslation.TransformPayloadTranslator> getTransformRehydrators() {
                return Collections.singletonMap(PTransformTranslation.COMBINE_TRANSFORM_URN, new CombinePayloadTranslator());
            }
        }
    }
}

