/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction;

import com.google.auto.value.AutoValue;
import java.util.Set;
import org.apache.beam.repackaged.beam_runners_core_construction_java.com.google.common.base.Preconditions;
import org.apache.beam.repackaged.beam_runners_core_construction_java.com.google.common.collect.ImmutableSet;
import org.apache.beam.repackaged.beam_runners_direct_java.model.pipeline.v1.RunnerApi;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.AutoValue_ModelCoders_KvCoderComponents;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.AutoValue_ModelCoders_WindowedValueCoderComponents;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.BeamUrns;

public class ModelCoders {
    public static final String BYTES_CODER_URN = BeamUrns.getUrn(RunnerApi.StandardCoders.Enum.BYTES);
    public static final String INT64_CODER_URN = BeamUrns.getUrn(RunnerApi.StandardCoders.Enum.VARINT);
    public static final String ITERABLE_CODER_URN = BeamUrns.getUrn(RunnerApi.StandardCoders.Enum.ITERABLE);
    public static final String KV_CODER_URN = BeamUrns.getUrn(RunnerApi.StandardCoders.Enum.KV);
    public static final String LENGTH_PREFIX_CODER_URN = BeamUrns.getUrn(RunnerApi.StandardCoders.Enum.LENGTH_PREFIX);
    public static final String GLOBAL_WINDOW_CODER_URN = BeamUrns.getUrn(RunnerApi.StandardCoders.Enum.GLOBAL_WINDOW);
    public static final String INTERVAL_WINDOW_CODER_URN = BeamUrns.getUrn(RunnerApi.StandardCoders.Enum.INTERVAL_WINDOW);
    public static final String WINDOWED_VALUE_CODER_URN = BeamUrns.getUrn(RunnerApi.StandardCoders.Enum.WINDOWED_VALUE);
    private static final Set<String> MODEL_CODER_URNS = ImmutableSet.of(BYTES_CODER_URN, INT64_CODER_URN, ITERABLE_CODER_URN, KV_CODER_URN, LENGTH_PREFIX_CODER_URN, GLOBAL_WINDOW_CODER_URN, new String[]{INTERVAL_WINDOW_CODER_URN, WINDOWED_VALUE_CODER_URN});

    private ModelCoders() {
    }

    public static Set<String> urns() {
        return MODEL_CODER_URNS;
    }

    public static WindowedValueCoderComponents getWindowedValueCoderComponents(RunnerApi.Coder coder) {
        Preconditions.checkArgument(WINDOWED_VALUE_CODER_URN.equals(coder.getSpec().getSpec().getUrn()));
        return new AutoValue_ModelCoders_WindowedValueCoderComponents(coder.getComponentCoderIds(0), coder.getComponentCoderIds(1));
    }

    public static RunnerApi.Coder windowedValueCoder(String elementCoderId, String windowCoderId) {
        return RunnerApi.Coder.newBuilder().setSpec(RunnerApi.SdkFunctionSpec.newBuilder().setSpec(RunnerApi.FunctionSpec.newBuilder().setUrn(WINDOWED_VALUE_CODER_URN))).addComponentCoderIds(elementCoderId).addComponentCoderIds(windowCoderId).build();
    }

    public static KvCoderComponents getKvCoderComponents(RunnerApi.Coder coder) {
        Preconditions.checkArgument(KV_CODER_URN.equals(coder.getSpec().getSpec().getUrn()));
        return new AutoValue_ModelCoders_KvCoderComponents(coder.getComponentCoderIds(0), coder.getComponentCoderIds(1));
    }

    public static RunnerApi.Coder kvCoder(String keyCoderId, String valueCoderId) {
        return RunnerApi.Coder.newBuilder().setSpec(RunnerApi.SdkFunctionSpec.newBuilder().setSpec(RunnerApi.FunctionSpec.newBuilder().setUrn(KV_CODER_URN))).addComponentCoderIds(keyCoderId).addComponentCoderIds(valueCoderId).build();
    }

    @AutoValue
    public static abstract class KvCoderComponents {
        public abstract String keyCoderId();

        public abstract String valueCoderId();
    }

    @AutoValue
    public static abstract class WindowedValueCoderComponents {
        public abstract String elementCoderId();

        public abstract String windowCoderId();
    }
}

