/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;

public class PipelineResources {
    public static List<String> detectClassPathResourcesToStage(ClassLoader classLoader) {
        if (!(classLoader instanceof URLClassLoader)) {
            String message = String.format("Unable to use ClassLoader to detect classpath elements. Current ClassLoader is %s, only URLClassLoaders are supported.", classLoader);
            throw new IllegalArgumentException(message);
        }
        ArrayList<String> files = new ArrayList<String>();
        for (URL url : ((URLClassLoader)classLoader).getURLs()) {
            try {
                files.add(new File(url.toURI()).getAbsolutePath());
            }
            catch (IllegalArgumentException | URISyntaxException e) {
                String message = String.format("Unable to convert url (%s) to file.", url);
                throw new IllegalArgumentException(message, e);
            }
        }
        return files;
    }
}

