/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.beam.repackaged.beam_runners_core_construction_java.com.google.common.base.Preconditions;
import org.apache.beam.repackaged.beam_runners_core_construction_java.com.google.common.collect.ArrayListMultimap;
import org.apache.beam.repackaged.beam_runners_core_construction_java.com.google.common.collect.ListMultimap;
import org.apache.beam.repackaged.beam_runners_direct_java.model.pipeline.v1.RunnerApi;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.PCollectionViewTranslation;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.PTransformTranslation;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.RehydratedComponents;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.SdkComponents;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.runners.TransformHierarchy;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionViews;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;

public class PipelineTranslation {
    public static RunnerApi.Pipeline toProto(Pipeline pipeline) {
        return PipelineTranslation.toProto(pipeline, SdkComponents.create());
    }

    public static RunnerApi.Pipeline toProto(final Pipeline pipeline, final SdkComponents components) {
        final HashSet<String> rootIds = new HashSet<String>();
        pipeline.traverseTopologically((Pipeline.PipelineVisitor)new Pipeline.PipelineVisitor.Defaults(){
            private final ListMultimap<TransformHierarchy.Node, AppliedPTransform<?, ?, ?>> children = ArrayListMultimap.create();

            public void leaveCompositeTransform(TransformHierarchy.Node node) {
                if (node.isRootNode()) {
                    for (AppliedPTransform<?, ?, ?> pipelineRoot : this.children.get(node)) {
                        rootIds.add(components.getExistingPTransformId(pipelineRoot));
                    }
                } else {
                    this.children.put(node.getEnclosingNode(), node.toAppliedPTransform(pipeline));
                    try {
                        components.registerPTransform(node.toAppliedPTransform(pipeline), this.children.get(node));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }

            public void visitPrimitiveTransform(TransformHierarchy.Node node) {
                this.children.put(node.getEnclosingNode(), node.toAppliedPTransform(pipeline));
                try {
                    components.registerPTransform(node.toAppliedPTransform(pipeline), Collections.emptyList());
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
        });
        return RunnerApi.Pipeline.newBuilder().setComponents(components.toComponents()).addAllRootTransformIds(rootIds).build();
    }

    private static DisplayData evaluateDisplayData(HasDisplayData component) {
        return DisplayData.from((HasDisplayData)component);
    }

    public static Pipeline fromProto(RunnerApi.Pipeline pipelineProto) throws IOException {
        TransformHierarchy transforms = new TransformHierarchy();
        Pipeline pipeline = Pipeline.forTransformHierarchy((TransformHierarchy)transforms, (PipelineOptions)PipelineOptionsFactory.create());
        RehydratedComponents rehydratedComponents = RehydratedComponents.forComponents(pipelineProto.getComponents()).withPipeline(pipeline);
        for (String rootId : pipelineProto.getRootTransformIdsList()) {
            PipelineTranslation.addRehydratedTransform(transforms, pipelineProto.getComponents().getTransformsOrThrow(rootId), pipeline, pipelineProto.getComponents().getTransformsMap(), rehydratedComponents);
        }
        return pipeline;
    }

    private static void addRehydratedTransform(TransformHierarchy transforms, RunnerApi.PTransform transformProto, Pipeline pipeline, Map<String, RunnerApi.PTransform> transformProtos, RehydratedComponents rehydratedComponents) throws IOException {
        HashMap rehydratedInputs = new HashMap();
        for (Map.Entry<String, String> entry : transformProto.getInputsMap().entrySet()) {
            rehydratedInputs.put(new TupleTag(entry.getKey()), rehydratedComponents.getPCollection(entry.getValue()));
        }
        HashMap rehydratedOutputs = new HashMap();
        for (Map.Entry<String, String> entry : transformProto.getOutputsMap().entrySet()) {
            rehydratedOutputs.put(new TupleTag(entry.getKey()), rehydratedComponents.getPCollection(entry.getValue()));
        }
        PTransformTranslation.RawPTransform<?, ?> rawPTransform = PTransformTranslation.rehydrate(transformProto, rehydratedComponents);
        if (PipelineTranslation.isPrimitive(transformProto)) {
            transforms.addFinalizedPrimitiveNode(transformProto.getUniqueName(), rehydratedInputs, rawPTransform, rehydratedOutputs);
        } else {
            transforms.pushFinalizedNode(transformProto.getUniqueName(), rehydratedInputs, rawPTransform, rehydratedOutputs);
            for (String childTransformId : transformProto.getSubtransformsList()) {
                PipelineTranslation.addRehydratedTransform(transforms, transformProtos.get(childTransformId), pipeline, transformProtos, rehydratedComponents);
            }
            transforms.popNode();
        }
    }

    private static Map<TupleTag<?>, PValue> sideInputMapToAdditionalInputs(RunnerApi.PTransform transformProto, RehydratedComponents rehydratedComponents, Map<TupleTag<?>, PValue> rehydratedInputs, Map<String, RunnerApi.SideInput> sideInputsMap) throws IOException {
        ArrayList views = new ArrayList();
        for (Map.Entry<String, RunnerApi.SideInput> sideInputEntry : sideInputsMap.entrySet()) {
            String localName = sideInputEntry.getKey();
            RunnerApi.SideInput sideInput = sideInputEntry.getValue();
            PCollection pCollection = (PCollection)Preconditions.checkNotNull(rehydratedInputs.get(new TupleTag(localName)));
            views.add(PCollectionViewTranslation.viewFromProto(sideInput, localName, pCollection, transformProto, rehydratedComponents));
        }
        return PCollectionViews.toAdditionalInputs(views);
    }

    private static boolean isPrimitive(RunnerApi.PTransform transformProto) {
        return transformProto.getSubtransformsCount() == 0 && !transformProto.getInputsMap().values().containsAll(transformProto.getOutputsMap().values());
    }
}

