/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.runners.fnexecution;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.BindableService;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.Server;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.ServerInterceptors;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.internal.ServerImpl;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.netty.NettyServerBuilder;
import org.apache.beam.repackaged.beam_runners_direct_java.model.pipeline.v1.Endpoints;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.fnexecution.GrpcContextHeaderAccessorProvider;
import org.apache.beam.repackaged.beam_runners_direct_java.sdk.fn.channel.SocketAddressFactory;
import org.apache.beam.repackaged.beam_runners_java_fn_execution.com.google.common.base.Preconditions;
import org.apache.beam.repackaged.beam_runners_java_fn_execution.com.google.common.net.HostAndPort;

public abstract class ServerFactory {
    public static ServerFactory createDefault() {
        return new InetSocketAddressServerFactory(UrlFactory.createDefault());
    }

    public static ServerFactory createWithUrlFactory(UrlFactory urlFactory) {
        return new InetSocketAddressServerFactory(urlFactory);
    }

    public abstract Server allocatePortAndCreate(BindableService var1, Endpoints.ApiServiceDescriptor.Builder var2) throws IOException;

    public abstract Server create(BindableService var1, Endpoints.ApiServiceDescriptor var2) throws IOException;

    @FunctionalInterface
    public static interface UrlFactory {
        public String createUrl(String var1, int var2);

        public static UrlFactory createDefault() {
            return (host, port) -> HostAndPort.fromParts(host, port).toString();
        }
    }

    public static class InetSocketAddressServerFactory
    extends ServerFactory {
        private final UrlFactory urlFactory;

        private InetSocketAddressServerFactory(UrlFactory urlFactory) {
            this.urlFactory = urlFactory;
        }

        @Override
        public Server allocatePortAndCreate(BindableService service, Endpoints.ApiServiceDescriptor.Builder apiServiceDescriptor) throws IOException {
            InetSocketAddress address = new InetSocketAddress(InetAddress.getLoopbackAddress(), 0);
            Server server = InetSocketAddressServerFactory.createServer(service, address);
            apiServiceDescriptor.setUrl(this.urlFactory.createUrl(address.getHostName(), server.getPort()));
            return server;
        }

        @Override
        public Server create(BindableService service, Endpoints.ApiServiceDescriptor serviceDescriptor) throws IOException {
            SocketAddress socketAddress = SocketAddressFactory.createFrom(serviceDescriptor.getUrl());
            Preconditions.checkArgument(socketAddress instanceof InetSocketAddress, "%s %s requires a host:port socket address, got %s", (Object)this.getClass().getSimpleName(), (Object)ServerFactory.class.getSimpleName(), (Object)serviceDescriptor.getUrl());
            return InetSocketAddressServerFactory.createServer(service, (InetSocketAddress)socketAddress);
        }

        private static Server createServer(BindableService service, InetSocketAddress socket) throws IOException {
            ServerImpl server = ((NettyServerBuilder)NettyServerBuilder.forPort(socket.getPort()).addService(ServerInterceptors.intercept(service, GrpcContextHeaderAccessorProvider.interceptor()))).maxMessageSize(Integer.MAX_VALUE).build();
            ((Server)server).start();
            return server;
        }
    }
}

