/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.runners.fnexecution.data;

import java.util.Queue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.stub.StreamObserver;
import org.apache.beam.repackaged.beam_runners_direct_java.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.repackaged.beam_runners_direct_java.model.fnexecution.v1.BeamFnDataGrpc;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.fnexecution.FnService;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.fnexecution.data.FnDataService;
import org.apache.beam.repackaged.beam_runners_direct_java.sdk.fn.data.BeamFnDataBufferingOutboundObserver;
import org.apache.beam.repackaged.beam_runners_direct_java.sdk.fn.data.BeamFnDataGrpcMultiplexer;
import org.apache.beam.repackaged.beam_runners_direct_java.sdk.fn.data.BeamFnDataInboundObserver;
import org.apache.beam.repackaged.beam_runners_direct_java.sdk.fn.data.CloseableFnDataReceiver;
import org.apache.beam.repackaged.beam_runners_direct_java.sdk.fn.data.FnDataReceiver;
import org.apache.beam.repackaged.beam_runners_direct_java.sdk.fn.data.InboundDataClient;
import org.apache.beam.repackaged.beam_runners_direct_java.sdk.fn.data.LogicalEndpoint;
import org.apache.beam.repackaged.beam_runners_java_fn_execution.com.google.common.util.concurrent.SettableFuture;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.util.WindowedValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcDataService
extends BeamFnDataGrpc.BeamFnDataImplBase
implements FnService,
FnDataService {
    private static final Logger LOG = LoggerFactory.getLogger(GrpcDataService.class);
    private final SettableFuture<BeamFnDataGrpcMultiplexer> connectedClient = SettableFuture.create();
    private final Queue<BeamFnDataGrpcMultiplexer> additionalMultiplexers = new LinkedBlockingQueue<BeamFnDataGrpcMultiplexer>();
    private final ExecutorService executor;

    public static GrpcDataService create(ExecutorService executor) {
        return new GrpcDataService(executor);
    }

    private GrpcDataService(ExecutorService executor) {
        this.executor = executor;
    }

    public StreamObserver<BeamFnApi.Elements> data(StreamObserver<BeamFnApi.Elements> outboundElementObserver) {
        LOG.info("Beam Fn Data client connected.");
        BeamFnDataGrpcMultiplexer multiplexer = new BeamFnDataGrpcMultiplexer(null, inboundObserver -> outboundElementObserver);
        if (!this.connectedClient.set(multiplexer)) {
            this.additionalMultiplexers.offer(multiplexer);
        }
        try {
            return ((BeamFnDataGrpcMultiplexer)this.connectedClient.get()).getInboundObserver();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws Exception {
        this.connectedClient.cancel(true);
        for (BeamFnDataGrpcMultiplexer additional : this.additionalMultiplexers) {
            try {
                additional.close();
            }
            catch (Exception exception) {}
        }
        if (!this.connectedClient.isCancelled()) {
            ((BeamFnDataGrpcMultiplexer)this.connectedClient.get()).close();
        }
    }

    @Override
    public <T> InboundDataClient receive(LogicalEndpoint inputLocation, Coder<WindowedValue<T>> coder, FnDataReceiver<WindowedValue<T>> listener) {
        LOG.debug("Registering receiver for instruction {} and target {}", (Object)inputLocation.getInstructionId(), (Object)inputLocation.getTarget());
        BeamFnDataInboundObserver observer = BeamFnDataInboundObserver.forConsumer(coder, listener);
        if (this.connectedClient.isDone()) {
            try {
                ((BeamFnDataGrpcMultiplexer)this.connectedClient.get()).registerConsumer(inputLocation, observer);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e.getCause());
            }
        } else {
            this.executor.submit(() -> {
                try {
                    ((BeamFnDataGrpcMultiplexer)this.connectedClient.get()).registerConsumer(inputLocation, observer);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e.getCause());
                }
            });
        }
        return observer;
    }

    @Override
    public <T> CloseableFnDataReceiver<WindowedValue<T>> send(LogicalEndpoint outputLocation, Coder<WindowedValue<T>> coder) {
        LOG.debug("Creating sender for instruction {} and target {}", (Object)outputLocation.getInstructionId(), (Object)outputLocation.getTarget());
        try {
            return BeamFnDataBufferingOutboundObserver.forLocation(outputLocation, coder, ((BeamFnDataGrpcMultiplexer)this.connectedClient.get(3L, TimeUnit.MINUTES)).getOutboundObserver());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (TimeoutException e) {
            throw new RuntimeException("No client connected within timeout", e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

