/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.runners.fnexecution.environment;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.concurrent.TimeoutException;
import org.apache.beam.repackaged.beam_runners_direct_java.model.pipeline.v1.RunnerApi;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.fnexecution.GrpcFnServer;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.fnexecution.artifact.ArtifactRetrievalService;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.fnexecution.control.ControlClientPool;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.fnexecution.control.FnApiControlClientPoolService;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.fnexecution.control.InstructionRequestHandler;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.fnexecution.environment.DockerCommand;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.fnexecution.environment.DockerContainerEnvironment;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.fnexecution.environment.EnvironmentFactory;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.fnexecution.environment.RemoteEnvironment;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.fnexecution.logging.GrpcLoggingService;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.fnexecution.provisioning.StaticGrpcProvisionService;
import org.apache.beam.repackaged.beam_runners_direct_java.sdk.fn.IdGenerator;
import org.apache.beam.repackaged.beam_runners_java_fn_execution.com.google.common.collect.ImmutableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerEnvironmentFactory
implements EnvironmentFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DockerEnvironmentFactory.class);
    private final DockerCommand docker;
    private final GrpcFnServer<FnApiControlClientPoolService> controlServiceServer;
    private final GrpcFnServer<GrpcLoggingService> loggingServiceServer;
    private final GrpcFnServer<ArtifactRetrievalService> retrievalServiceServer;
    private final GrpcFnServer<StaticGrpcProvisionService> provisioningServiceServer;
    private final IdGenerator idGenerator;
    private final ControlClientPool.Source clientSource;

    public static DockerEnvironmentFactory forServices(GrpcFnServer<FnApiControlClientPoolService> controlServiceServer, GrpcFnServer<GrpcLoggingService> loggingServiceServer, GrpcFnServer<ArtifactRetrievalService> retrievalServiceServer, GrpcFnServer<StaticGrpcProvisionService> provisioningServiceServer, ControlClientPool.Source clientSource, IdGenerator idGenerator) {
        return DockerEnvironmentFactory.forServicesWithDocker(DockerCommand.getDefault(), controlServiceServer, loggingServiceServer, retrievalServiceServer, provisioningServiceServer, clientSource, idGenerator);
    }

    static DockerEnvironmentFactory forServicesWithDocker(DockerCommand docker, GrpcFnServer<FnApiControlClientPoolService> controlServiceServer, GrpcFnServer<GrpcLoggingService> loggingServiceServer, GrpcFnServer<ArtifactRetrievalService> retrievalServiceServer, GrpcFnServer<StaticGrpcProvisionService> provisioningServiceServer, ControlClientPool.Source clientSource, IdGenerator idGenerator) {
        return new DockerEnvironmentFactory(docker, controlServiceServer, loggingServiceServer, retrievalServiceServer, provisioningServiceServer, idGenerator, clientSource);
    }

    private DockerEnvironmentFactory(DockerCommand docker, GrpcFnServer<FnApiControlClientPoolService> controlServiceServer, GrpcFnServer<GrpcLoggingService> loggingServiceServer, GrpcFnServer<ArtifactRetrievalService> retrievalServiceServer, GrpcFnServer<StaticGrpcProvisionService> provisioningServiceServer, IdGenerator idGenerator, ControlClientPool.Source clientSource) {
        this.docker = docker;
        this.controlServiceServer = controlServiceServer;
        this.loggingServiceServer = loggingServiceServer;
        this.retrievalServiceServer = retrievalServiceServer;
        this.provisioningServiceServer = provisioningServiceServer;
        this.idGenerator = idGenerator;
        this.clientSource = clientSource;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public RemoteEnvironment createEnvironment(RunnerApi.Environment environment) throws Exception {
        String workerId = this.idGenerator.getId();
        Path workerPersistentDirectory = Files.createTempDirectory("worker_persistent_directory", new FileAttribute[0]);
        Path semiPersistentDirectory = Files.createTempDirectory("semi_persistent_dir", new FileAttribute[0]);
        String containerImage = environment.getUrl();
        String loggingEndpoint = this.loggingServiceServer.getApiServiceDescriptor().getUrl();
        String artifactEndpoint = this.retrievalServiceServer.getApiServiceDescriptor().getUrl();
        String provisionEndpoint = this.provisioningServiceServer.getApiServiceDescriptor().getUrl();
        String controlEndpoint = this.controlServiceServer.getApiServiceDescriptor().getUrl();
        ImmutableList<String> volArg = ImmutableList.of("-v", String.format("%s:%s", workerPersistentDirectory, semiPersistentDirectory), "--network=host");
        ImmutableList<String> args = ImmutableList.of(String.format("--id=%s", workerId), String.format("--logging_endpoint=%s", loggingEndpoint), String.format("--artifact_endpoint=%s", artifactEndpoint), String.format("--provision_endpoint=%s", provisionEndpoint), String.format("--control_endpoint=%s", controlEndpoint), String.format("--semi_persist_dir=%s", semiPersistentDirectory));
        LOG.debug("Creating Docker Container with ID {}", (Object)workerId);
        String containerId = null;
        InstructionRequestHandler instructionHandler = null;
        try {
            containerId = this.docker.runImage(containerImage, volArg, args);
            LOG.debug("Created Docker Container with Container ID {}", (Object)containerId);
            while (instructionHandler == null) {
                try {
                    instructionHandler = this.clientSource.take(workerId, Duration.ofMinutes(2L));
                }
                catch (TimeoutException timeoutEx) {
                    LOG.info("Still waiting for startup of environment {} for worker id {}", (Object)environment.getUrl(), (Object)workerId);
                }
                catch (InterruptedException interruptEx) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(interruptEx);
                    return DockerContainerEnvironment.create(this.docker, environment, containerId, instructionHandler);
                }
            }
        }
        catch (Exception e) {
            if (containerId == null) throw e;
            try {
                this.docker.killContainer(containerId);
                throw e;
            }
            catch (Exception dockerException) {
                e.addSuppressed(dockerException);
            }
            throw e;
        }
    }
}

