/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.runners.fnexecution.logging;

import org.apache.beam.repackaged.beam_runners_direct_java.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.fnexecution.logging.LogWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slf4jLogWriter
implements LogWriter {
    public static LogWriter getDefault() {
        return new Slf4jLogWriter();
    }

    private Slf4jLogWriter() {
    }

    @Override
    public void log(BeamFnApi.LogEntry entry) {
        String location = entry.getLogLocation();
        Logger log = location != null ? LoggerFactory.getLogger((String)location) : LoggerFactory.getLogger((String)"RemoteLog");
        String message = entry.getMessage();
        String trace = entry.getTrace();
        switch (entry.getSeverity()) {
            case ERROR: 
            case CRITICAL: {
                if (trace == null) {
                    log.error(message);
                    break;
                }
                log.error("{} {}", (Object)message, (Object)trace);
                break;
            }
            case WARN: {
                if (trace == null) {
                    log.warn(message);
                    break;
                }
                log.warn("{} {}", (Object)message, (Object)trace);
                break;
            }
            case INFO: 
            case NOTICE: {
                log.info(message);
                break;
            }
            case DEBUG: {
                log.debug(message);
                break;
            }
            case UNSPECIFIED: 
            case TRACE: {
                log.trace(message);
                break;
            }
            default: {
                log.warn("Unknown message severity {}", (Object)entry.getSeverity());
                log.info(message);
            }
        }
    }
}

