/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.runners.fnexecution.wire;

import java.util.Set;
import org.apache.beam.repackaged.beam_runners_direct_java.model.pipeline.v1.RunnerApi;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.ModelCoders;
import org.apache.beam.repackaged.beam_runners_java_fn_execution.com.google.common.collect.Sets;

public class LengthPrefixUnknownCoders {
    public static RunnerApi.MessageWithComponents forCoder(String coderId, RunnerApi.Components components, boolean replaceWithByteArrayCoder) {
        RunnerApi.Coder currentCoder = components.getCodersOrThrow(coderId);
        if (ModelCoders.LENGTH_PREFIX_CODER_URN.equals(currentCoder.getSpec().getSpec().getUrn())) {
            if (replaceWithByteArrayCoder) {
                return LengthPrefixUnknownCoders.createLengthPrefixByteArrayCoder(coderId, components);
            }
            RunnerApi.MessageWithComponents.Builder rvalBuilder = RunnerApi.MessageWithComponents.newBuilder();
            rvalBuilder.setCoder(currentCoder);
            rvalBuilder.setComponents(components);
            return rvalBuilder.build();
        }
        if (ModelCoders.urns().contains(currentCoder.getSpec().getSpec().getUrn())) {
            return LengthPrefixUnknownCoders.lengthPrefixUnknownComponentCoders(coderId, components, replaceWithByteArrayCoder);
        }
        return LengthPrefixUnknownCoders.lengthPrefixUnknownCoder(coderId, components, replaceWithByteArrayCoder);
    }

    private static RunnerApi.MessageWithComponents lengthPrefixUnknownComponentCoders(String coderId, RunnerApi.Components components, boolean replaceWithByteArrayCoder) {
        RunnerApi.MessageWithComponents.Builder rvalBuilder = RunnerApi.MessageWithComponents.newBuilder();
        RunnerApi.Coder currentCoder = components.getCodersOrThrow(coderId);
        RunnerApi.Coder.Builder updatedCoder = currentCoder.toBuilder();
        updatedCoder.clearComponentCoderIds();
        for (String componentCoderId : currentCoder.getComponentCoderIdsList()) {
            RunnerApi.MessageWithComponents componentCoder = LengthPrefixUnknownCoders.forCoder(componentCoderId, components, replaceWithByteArrayCoder);
            String newComponentCoderId = componentCoderId;
            if (!components.getCodersOrThrow(componentCoderId).equals(componentCoder.getCoder())) {
                newComponentCoderId = LengthPrefixUnknownCoders.generateUniqueId(coderId + "-length_prefix", Sets.union(components.getCodersMap().keySet(), rvalBuilder.getComponents().getCodersMap().keySet()));
            }
            updatedCoder.addComponentCoderIds(newComponentCoderId);
            rvalBuilder.getComponentsBuilder().putCoders(newComponentCoderId, componentCoder.getCoder());
            rvalBuilder.getComponentsBuilder().putAllCoders(componentCoder.getComponents().getCodersMap());
        }
        rvalBuilder.setCoder(updatedCoder);
        return rvalBuilder.build();
    }

    private static RunnerApi.MessageWithComponents lengthPrefixUnknownCoder(String coderId, RunnerApi.Components components, boolean replaceWithByteArrayCoder) {
        RunnerApi.MessageWithComponents.Builder rvalBuilder = RunnerApi.MessageWithComponents.newBuilder();
        RunnerApi.Coder currentCoder = components.getCodersOrThrow(coderId);
        String lengthPrefixComponentCoderId = coderId;
        if (replaceWithByteArrayCoder) {
            return LengthPrefixUnknownCoders.createLengthPrefixByteArrayCoder(coderId, components);
        }
        rvalBuilder.getComponentsBuilder().putCoders(coderId, currentCoder);
        rvalBuilder.getCoderBuilder().addComponentCoderIds(lengthPrefixComponentCoderId).getSpecBuilder().getSpecBuilder().setUrn(ModelCoders.LENGTH_PREFIX_CODER_URN);
        return rvalBuilder.build();
    }

    private static RunnerApi.MessageWithComponents createLengthPrefixByteArrayCoder(String coderId, RunnerApi.Components components) {
        RunnerApi.MessageWithComponents.Builder rvalBuilder = RunnerApi.MessageWithComponents.newBuilder();
        String byteArrayCoderId = LengthPrefixUnknownCoders.generateUniqueId(coderId + "-byte_array", Sets.union(components.getCodersMap().keySet(), rvalBuilder.getComponents().getCodersMap().keySet()));
        RunnerApi.Coder.Builder byteArrayCoder = RunnerApi.Coder.newBuilder();
        byteArrayCoder.getSpecBuilder().getSpecBuilder().setUrn(ModelCoders.BYTES_CODER_URN);
        rvalBuilder.getComponentsBuilder().putCoders(byteArrayCoderId, byteArrayCoder.build());
        rvalBuilder.getCoderBuilder().addComponentCoderIds(byteArrayCoderId).getSpecBuilder().getSpecBuilder().setUrn(ModelCoders.LENGTH_PREFIX_CODER_URN);
        return rvalBuilder.build();
    }

    static String generateUniqueId(String prefix, Set<String> existingIds) {
        int i = 0;
        while (existingIds.contains(prefix + i)) {
            ++i;
        }
        return prefix + i;
    }
}

