/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.runners.fnexecution.wire;

import java.io.IOException;
import java.util.function.Predicate;
import org.apache.beam.repackaged.beam_runners_direct_java.model.pipeline.v1.RunnerApi;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.CoderTranslation;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.ModelCoders;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.RehydratedComponents;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.SyntheticComponents;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.graph.PipelineNode;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.fnexecution.wire.LengthPrefixUnknownCoders;
import org.apache.beam.repackaged.beam_runners_java_fn_execution.com.google.common.base.Preconditions;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.util.WindowedValue;

public class WireCoders {
    public static RunnerApi.MessageWithComponents createSdkWireCoder(PipelineNode.PCollectionNode pCollectionNode, RunnerApi.Components components, Predicate<String> idUsed) {
        return WireCoders.createWireCoder(pCollectionNode, components, idUsed, false);
    }

    public static RunnerApi.MessageWithComponents createRunnerWireCoder(PipelineNode.PCollectionNode pCollectionNode, RunnerApi.Components components, Predicate<String> idUsed) {
        return WireCoders.createWireCoder(pCollectionNode, components, idUsed, true);
    }

    public static <T> Coder<WindowedValue<T>> instantiateRunnerWireCoder(PipelineNode.PCollectionNode pCollectionNode, RunnerApi.Components components) throws IOException {
        RunnerApi.MessageWithComponents protoCoder = WireCoders.createRunnerWireCoder(pCollectionNode, components, components::containsCoders);
        Coder<?> javaCoder = CoderTranslation.fromProto(protoCoder.getCoder(), RehydratedComponents.forComponents(protoCoder.getComponents()));
        Preconditions.checkArgument(javaCoder instanceof WindowedValue.FullWindowedValueCoder, "Unexpected Deserialized %s type, expected %s, got %s", (Object)RunnerApi.Coder.class.getSimpleName(), (Object)WindowedValue.FullWindowedValueCoder.class.getSimpleName(), javaCoder.getClass());
        return javaCoder;
    }

    private static RunnerApi.MessageWithComponents createWireCoder(PipelineNode.PCollectionNode pCollectionNode, RunnerApi.Components components, Predicate<String> idUsed, boolean useByteArrayCoder) {
        String elementCoderId = pCollectionNode.getPCollection().getCoderId();
        String windowingStrategyId = pCollectionNode.getPCollection().getWindowingStrategyId();
        String windowCoderId = components.getWindowingStrategiesOrThrow(windowingStrategyId).getWindowCoderId();
        RunnerApi.Coder windowedValueCoder = ModelCoders.windowedValueCoder(elementCoderId, windowCoderId);
        String windowedValueId = SyntheticComponents.uniqueId(String.format("fn/wire/%s", pCollectionNode.getId()), idUsed);
        return LengthPrefixUnknownCoders.forCoder(windowedValueId, components.toBuilder().putCoders(windowedValueId, windowedValueCoder).build(), useByteArrayCoder);
    }

    private WireCoders() {
    }
}

